/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.jobservice.configuration;

import com.mongodb.client.MongoClient;
import eu.dnetlib.jobcore.mongo.MongoConfiguration;
import eu.dnetlib.jobcore.mongo.MongoConnection;
import eu.dnetlib.jobservice.configuration.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"eu.dnetlib.jobservice"}, mongoTemplateRef="main")
@Import(value={MongoConfiguration.class})
public class JobMongoConnection
extends MongoConnection {
    @Autowired
    public JobMongoConnection(Properties properties) {
        this.mongo = properties.getMongo();
    }

    @Bean
    @Primary
    public MongoDatabaseFactory mongoDatabaseFactory(MongoClient mongoClient) {
        return super.mongoDatabaseFactory(mongoClient);
    }

    @Bean
    @Primary
    public MappingMongoConverter mappingMongoConverter(MongoDatabaseFactory factory, MongoMappingContext context) {
        return super.mappingMongoConverter(factory, context);
    }

    @Bean(name={"main"})
    @Primary
    public MongoTemplate getMongoTemplate(MongoClient mongoClient) {
        return super.getMongoTemplate(mongoClient);
    }

    @Bean(name={"mainClient"})
    @Primary
    public MongoClient getMongoClient() {
        return super.getMongoClient();
    }
}

