/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.jobservice.services;

import eu.dnetlib.jobcore.entities.Job;
import eu.dnetlib.jobcore.entities.JobRequest;
import eu.dnetlib.jobcore.entities.JobStatus;
import eu.dnetlib.jobcore.handler.JobHandler;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class JobService {
    private final Map<String, Job> jobs = new ConcurrentHashMap();
    private final MongoTemplate mongoTemplate;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final List<JobHandler> jobHandlers;

    @Autowired
    public JobService(MongoTemplate mongoTemplate, List<JobHandler> handlers) {
        this.mongoTemplate = mongoTemplate;
        this.jobHandlers = handlers;
    }

    public String startJob(JobRequest request) {
        String jobId = UUID.randomUUID().toString();
        Job job = new Job(request, new JobStatus(JobStatus.State.RUNNING, Double.valueOf(0.0)), this.jobHandlers.stream().filter(h -> h.getType().equals(request.getType())).findFirst().orElseThrow(() -> new NotFoundException("job type not found")));
        this.jobs.put(jobId, job);
        this.executor.submit(() -> job.getHandler().runJob(jobId, job));
        return jobId;
    }

    public JobStatus getStatus(String jobId) {
        return this.jobs.getOrDefault(jobId, new Job()).getStatus();
    }

    public Object getResult(String type, String id) {
        JobHandler handler = this.jobHandlers.stream().filter(h -> h.getType().equals(type)).findFirst().orElse(null);
        if (handler == null) {
            throw new NotFoundException("job type not found");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)handler.getIDField()).is((Object)id));
        Object result = this.mongoTemplate.findOne(query, handler.getResultClass(), handler.getType());
        if (result == null) {
            throw new NotFoundException(handler.getResultClass().getName() + " not found");
        }
        return result;
    }
}

