/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.jobservice.controllers;

import eu.dnetlib.jobcore.entities.JobRequest;
import eu.dnetlib.jobcore.entities.JobStatus;
import eu.dnetlib.jobservice.services.JobService;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/process"})
public class JobController {
    private final JobService jobService;

    public JobController(JobService jobService) {
        this.jobService = jobService;
    }

    @PostMapping(value={"/start"})
    public ResponseEntity<Map<String, String>> startJob(@RequestBody JobRequest request) {
        String jobId = this.jobService.startJob(request);
        return ResponseEntity.ok(Map.of("jobId", jobId));
    }

    @GetMapping(value={"/progress/{jobId}"})
    public ResponseEntity<JobStatus> getProgress(@PathVariable String jobId) {
        return ResponseEntity.ok((Object)this.jobService.getStatus(jobId));
    }

    @GetMapping(value={"/result/{type}/{id}"})
    public ResponseEntity<Object> getResult(@PathVariable String type, @PathVariable String id) {
        return ResponseEntity.ok((Object)this.jobService.getResult(type, id));
    }
}

