/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.loginservice.security.initiliazers;

import eu.dnetlib.loginservice.properties.Properties;
import eu.dnetlib.loginservice.utils.ScopeReader;
import java.util.Collections;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Configurations {
    private final Properties properties;
    private final ScopeReader scopeReader;

    @Autowired
    public Configurations(Properties properties, ScopeReader scopeReader) {
        this.properties = properties;
        this.scopeReader = scopeReader;
    }

    @Bean
    public ServerConfiguration serverConfiguration() {
        String issuer = this.properties.getOidc().getIssuer();
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        serverConfiguration.setIssuer(issuer);
        Boolean keycloak = this.properties.getKeycloak();
        if (keycloak.booleanValue()) {
            serverConfiguration.setAuthorizationEndpointUri(issuer + "/protocol/openid-connect/auth");
            serverConfiguration.setTokenEndpointUri(issuer + "/protocol/openid-connect/token");
            serverConfiguration.setUserInfoUri(issuer + "/protocol/openid-connect/userinfo");
            serverConfiguration.setJwksUri(issuer + "/protocol/openid-connect/certs");
        } else {
            serverConfiguration.setAuthorizationEndpointUri(issuer + "authorize");
            serverConfiguration.setTokenEndpointUri(issuer + "token");
            serverConfiguration.setUserInfoUri(issuer + "userinfo");
            serverConfiguration.setJwksUri(issuer + "jwk");
        }
        serverConfiguration.setRevocationEndpointUri(issuer + "revoke");
        return serverConfiguration;
    }

    @Bean
    public RegisteredClient registeredClient() {
        RegisteredClient client = new RegisteredClient();
        client.setClientId(this.properties.getOidc().getId());
        client.setClientSecret(this.properties.getOidc().getSecret());
        client.setScope(this.scopeReader.getScopes());
        client.setTokenEndpointAuthMethod(ClientDetailsEntity.AuthMethod.SECRET_BASIC);
        client.setRedirectUris(Collections.singleton(this.properties.getOidc().getHome()));
        return client;
    }
}

