/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.loginservice.controllers;

import eu.dnetlib.authentication.configuration.AuthenticationConfiguration;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HealthController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final AuthenticationConfiguration configuration;

    @Autowired
    public HealthController(AuthenticationConfiguration configuration) {
        this.configuration = configuration;
    }

    @RequestMapping(value={"", "/health_check"}, method={RequestMethod.GET})
    public String hello() {
        this.log.debug("Hello from Login service!");
        return "Hello from Login service!";
    }

    @PreAuthorize(value="hasAnyAuthority('PORTAL_ADMINISTRATOR')")
    @RequestMapping(value={"/health_check/advanced"}, method={RequestMethod.GET})
    public Map<String, String> checkEverything() {
        return this.configuration.getProperties();
    }
}

