/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.loginservice.configuration;

import eu.dnetlib.loginservice.configuration.APIProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@Profile(value={"swagger"})
@EnableSwagger2
public class SwaggerConfig
extends WebMvcConfigurerAdapter {
    private final APIProperties apiProperties;

    @Autowired
    public SwaggerConfig(APIProperties apiProperties) {
        this.apiProperties = apiProperties;
    }

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"eu.dnetlib.loginservice.controllers")).paths(PathSelectors.any()).build();
    }

    @Bean
    public Docket createRestApiLoginCore() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).groupName("Login Core").select().apis(RequestHandlerSelectors.basePackage((String)"eu.dnetlib.authentication.controllers")).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.apiProperties.getTitle()).description(this.apiProperties.getDescription()).version(this.apiProperties.getVersion()).build();
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/v2/api-docs", "/v2/api-docs");
        registry.addRedirectViewController("/swagger-resources/configuration/ui", "/swagger-resources/configuration/ui");
        registry.addRedirectViewController("/swagger-resources/configuration/security", "/swagger-resources/configuration/security");
        registry.addRedirectViewController("/swagger-resources", "/swagger-resources");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui.html**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/swagger-ui.html"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }
}

