/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.network.configuration;

import com.mongodb.client.MongoClient;
import eu.dnetlib.jobcore.mongo.MongoConfiguration;
import eu.dnetlib.jobcore.mongo.MongoConnection;
import eu.dnetlib.network.configuration.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"eu.dnetlib.network.dao"}, mongoTemplateRef="network")
@Import(value={MongoConfiguration.class})
public class NetworkMongoConnection
extends MongoConnection {
    @Autowired
    public NetworkMongoConnection(Properties properties) {
        this.mongo = properties.getMongo();
    }

    @Bean(value={"networkMongoDatabaseFactory"})
    public MongoDatabaseFactory mongoDatabaseFactory(@Qualifier(value="networkMongoClient") MongoClient mongoClient) {
        return super.mongoDatabaseFactory(mongoClient);
    }

    @Bean(value={"networkMappingMongoConverter"})
    public MappingMongoConverter mappingMongoConverter(@Autowired(required=false) @Qualifier(value="mainMappingMongoConverter") MappingMongoConverter mappingMongoConverter, @Qualifier(value="networkMongoDatabaseFactory") MongoDatabaseFactory factory, MongoMappingContext context) {
        if (mappingMongoConverter == null) {
            return super.mappingMongoConverter(factory, context);
        }
        return mappingMongoConverter;
    }

    @Bean(value={"network"})
    public MongoTemplate getMongoTemplate(@Autowired(required=false) @Qualifier(value="main") MongoTemplate mongoTemplate, @Qualifier(value="networkMongoClient") MongoClient mongoClient) {
        if (mongoTemplate == null) {
            return super.getMongoTemplate(mongoClient);
        }
        return mongoTemplate;
    }

    @Bean(value={"networkMongoClient"})
    public MongoClient getMongoClient(@Autowired(required=false) @Qualifier(value="mainClient") MongoClient mongoClient) {
        if (mongoClient == null) {
            return super.getMongoClient();
        }
        return mongoClient;
    }
}

