/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.network.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import eu.dnetlib.jobcore.entities.Job;
import eu.dnetlib.jobcore.entities.JobStatus;
import eu.dnetlib.jobcore.handler.JobHandler;
import eu.dnetlib.network.entities.Network;
import eu.dnetlib.network.services.NetworkService;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.UnprocessableException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NetworkHandler
implements JobHandler {
    private final NetworkService service;

    @Autowired
    public NetworkHandler(NetworkService service) {
        this.service = service;
    }

    public String getType() {
        return "network";
    }

    public String getIDField() {
        return "orcid";
    }

    public Class<?> getResultClass() {
        return Network.class;
    }

    public void runJob(String jobId, Job job) {
        try {
            this.service.createNetwork((String)job.getRequest().getParameters().get("orcid"), jobId, job.getStatus());
            job.getStatus().setProgress(1.0);
            job.getStatus().setStatus(JobStatus.State.FINISHED);
        }
        catch (JsonProcessingException e) {
            job.getStatus().setStatus(JobStatus.State.STOPPED);
            throw new UnprocessableException("orcid is missing");
        }
    }
}

