/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.network.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.jobcore.entities.JobStatus;
import eu.dnetlib.network.configuration.Properties;
import eu.dnetlib.network.dao.LinkRepository;
import eu.dnetlib.network.dao.NetworkRepository;
import eu.dnetlib.network.dao.NodeRepository;
import eu.dnetlib.network.entities.Link;
import eu.dnetlib.network.entities.Network;
import eu.dnetlib.network.entities.Node;
import eu.dnetlib.network.entities.dto.SolrResponse;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class NetworkService {
    private final Properties properties;
    private final LinkRepository linkRepository;
    private final NodeRepository nodeRepository;
    private final NetworkRepository networkRepository;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public NetworkService(Properties properties, LinkRepository linkRepository, NodeRepository nodeRepository, NetworkRepository networkRepository, RestTemplate restTemplate) {
        this.properties = properties;
        this.linkRepository = linkRepository;
        this.nodeRepository = nodeRepository;
        this.networkRepository = networkRepository;
        this.restTemplate = restTemplate;
    }

    public Network createNetwork(String orcid) throws JsonProcessingException {
        return this.createNetwork(orcid, null, null);
    }

    public Network createNetwork(String orcid, String id, JobStatus status) throws JsonProcessingException {
        Optional<Network> network = this.networkRepository.findByOrcid(orcid);
        network.ifPresent(arg_0 -> ((NetworkRepository)this.networkRepository).delete(arg_0));
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String url = this.properties.getSearchURL() + "/browseAll/researcher-works?orcid=" + orcid;
        SolrResponse response = (SolrResponse)this.objectMapper.readValue((String)this.restTemplate.getForEntity(url, String.class, new Object[0]).getBody(), SolrResponse.class);
        ArrayList<Node> nodes = new ArrayList<Node>(response.getBody().getResults().stream().flatMap(result -> result.getResult().getAuthor().stream().filter(author -> author.getPid() != null)).flatMap(author -> author.getPid().stream().filter(pid -> pid.getTypeCode().equalsIgnoreCase("orcid") && pid.getValue() != null).map(pid -> this.getNode(pid.getValue(), author.getFullname()))).distinct().toList());
        int combinations = nodes.size() * (nodes.size() - 1) / 2;
        int current = 0;
        if (status != null) {
            status.setProgress(0.0);
        }
        ArrayList<Link> links = new ArrayList<Link>();
        for (int i = 0; i < nodes.size(); ++i) {
            Node a = (Node)nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node b = (Node)nodes.get(j);
                try {
                    Link link2 = this.getLink(a, b);
                    if (link2.getCount() > 0L) {
                        links.add(link2);
                    }
                    if (status == null) continue;
                    status.setProgress((double)(++current) / (double)combinations);
                    continue;
                }
                catch (Exception e) {
                    if (status == null) continue;
                    status.addError(e.getMessage());
                }
            }
        }
        return (Network)this.networkRepository.save(new Network(id, orcid, nodes, links.stream().map(link -> List.of(link.getSource(), link.getTarget(), Long.valueOf(link.getCount()))).toList()));
    }

    public Node getNode(String orcid, String name) {
        Optional<Node> node = this.nodeRepository.findByOrcid(orcid);
        if (node.isPresent()) {
            return node.get();
        }
        try {
            return this.createNode(orcid, name);
        }
        catch (JsonProcessingException e) {
            throw new NotFoundException("Could not find node with ORCID: " + orcid);
        }
    }

    public Node createNode(String orcid, String name) throws JsonProcessingException {
        String url = this.properties.getSearchURL() + "/researchProducts/facetSearch?page=0&size=0&authorOrcid=" + orcid;
        SolrResponse response = (SolrResponse)this.objectMapper.readValue((String)this.restTemplate.getForEntity(url, String.class, new Object[0]).getBody(), SolrResponse.class);
        Node node = new Node(orcid, name, response.getHeader().getTotal());
        return (Node)this.nodeRepository.save(node);
    }

    public Link getLink(Node a, Node b) throws JsonProcessingException {
        Optional<Link> link = this.linkRepository.findLink(a.getOrcid(), b.getOrcid());
        if (link.isPresent()) {
            return link.get();
        }
        return this.createLink(a, b);
    }

    public Link createLink(Node a, Node b) throws JsonProcessingException {
        String url = this.properties.getSearchURL() + "/researchProducts/facetSearch?page=0&size=0&authorOrcid=" + a.getOrcid() + " AND " + b.getOrcid();
        SolrResponse response = (SolrResponse)this.objectMapper.readValue((String)this.restTemplate.getForEntity(url, String.class, new Object[0]).getBody(), SolrResponse.class);
        Link link = new Link(a.getOrcid(), b.getOrcid(), response.getHeader().getTotal());
        return (Link)this.linkRepository.save(link);
    }
}

