/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.csv;

import eu.dnetlib.dhp.schema.solr.CodeLabel;
import eu.dnetlib.dhp.schema.solr.Organization;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.helpers.csv.OrganizationCsv;
import eu.dnetlib.mappers.csv.OrganizationCsvMapper;
import org.springframework.stereotype.Component;

@Component
public class OrganizationCsvMapperImpl
implements OrganizationCsvMapper {
    public OrganizationCsv toOrganizationCsv(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        OrganizationCsv organizationCsv = new OrganizationCsv();
        organizationCsv.setName(this.solrRecordOrganizationLegalname(solrRecord));
        organizationCsv.setCountry(this.solrRecordOrganizationCountryLabel(solrRecord));
        return organizationCsv;
    }

    private String solrRecordOrganizationLegalname(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Organization organization = solrRecord.getOrganization();
        if (organization == null) {
            return null;
        }
        String legalname = organization.getLegalname();
        if (legalname == null) {
            return null;
        }
        return legalname;
    }

    private String solrRecordOrganizationCountryLabel(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Organization organization = solrRecord.getOrganization();
        if (organization == null) {
            return null;
        }
        CodeLabel country = organization.getCountry();
        if (country == null) {
            return null;
        }
        String label = country.getLabel();
        if (label == null) {
            return null;
        }
        return label;
    }
}

