/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dto.request.validators;

import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.PagingRequest;
import eu.dnetlib.dto.request.validators.EntityFieldConstraint;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class EntityRequestValidator
implements ConstraintValidator<EntityFieldConstraint, EntityRequest> {
    private static final Map<EntityRequest.Type, String> validSortPatterns = new HashMap();
    private final Set<String> defaultEntityParams = Stream.of(EntityRequest.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
    private final Set<String> defaultPagingParams = Stream.of(PagingRequest.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
    private final Set<String> defaultFacetParams = Stream.of(FacetRequest.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
    private Set<String> validParams = new HashSet();
    private EntityRequest.Type type;

    public void initialize(EntityFieldConstraint constraintAnnotation) {
        this.type = constraintAnnotation.type();
        this.validParams.addAll(this.defaultEntityParams);
        this.validParams.addAll(this.defaultPagingParams);
        this.validParams.addAll(this.defaultFacetParams);
        super.initialize((Annotation)constraintAnnotation);
    }

    public boolean isValid(EntityRequest entityRequest, ConstraintValidatorContext constraintValidatorContext) {
        this.validParams.addAll(Stream.of(entityRequest.getClass().getDeclaredFields()).map(Field::getName).collect(Collectors.toSet()));
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            if (this.validParams.contains(key)) continue;
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("Unexpected request parameter: " + key + ". Allowed values are: " + String.valueOf(this.validParams)).addConstraintViolation();
            return false;
        }
        if (!Pattern.matches((String)validSortPatterns.get(this.type), entityRequest.getSortBy())) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("sortBy parameter is not valid. Valid pattern for " + String.valueOf(this.type) + " is: " + (String)validSortPatterns.get(this.type)).addConstraintViolation();
            return false;
        }
        return true;
    }

    static {
        validSortPatterns.put(EntityRequest.Type.product, "^((relevance|publicationDate|dateOfCollection|influence|popularity|citationCount|impulse)\\s+(ASC|DESC),?\\s*)+$");
        validSortPatterns.put(EntityRequest.Type.project, "^((relevance|startDate|endDate)\\s+(ASC|DESC),?\\s*)+$");
        validSortPatterns.put(EntityRequest.Type.datasource, "^((relevance)\\s+(ASC|DESC),?\\s*)+$");
        validSortPatterns.put(EntityRequest.Type.service, "^((relevance)\\s+(ASC|DESC),?\\s*)+$");
        validSortPatterns.put(EntityRequest.Type.organization, "^((relevance)\\s+(ASC|DESC),?\\s*)+$");
    }
}

