/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers;

import eu.dnetlib.exception.SyntaxErrorException;
import eu.dnetlib.mappers.Utils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String cleanKeywords(String input) {
        if (input == null || input.isBlank()) {
            return "";
        }
        return Utils.cleanRecursive((String)input, (int)0, (int)input.length()).result.trim();
    }

    private static ParseResult cleanRecursive(String input, int start, int end) {
        StringBuilder result = new StringBuilder();
        StringBuilder token = new StringBuilder();
        while (start < end) {
            char c = input.charAt(start);
            if (Character.isWhitespace(c)) {
                if (token.length() > 0) {
                    result.append(ClientUtils.escapeQueryChars((String)token.toString()));
                    token.setLength(0);
                }
                if (result.length() == 0 || result.charAt(result.length() - 1) != ' ') {
                    result.append(' ');
                }
                ++start;
                continue;
            }
            if (c == '(') {
                if (token.length() > 0) {
                    result.append(ClientUtils.escapeQueryChars((String)token.toString()));
                    token.setLength(0);
                }
                result.append('(');
                ParseResult nested = Utils.cleanRecursive((String)input, (int)(start + 1), (int)end);
                result.append(nested.result);
                result.append(')');
                start = nested.nextIndex + 1;
                continue;
            }
            if (c == ')') {
                if (token.length() > 0) {
                    result.append(ClientUtils.escapeQueryChars((String)token.toString()));
                    token.setLength(0);
                }
                return new ParseResult(result.toString(), start);
            }
            if (c == '\'' || c == '\"') {
                if (token.length() > 0) {
                    result.append(ClientUtils.escapeQueryChars((String)token.toString()));
                    token.setLength(0);
                }
                char quote = c;
                result.append(quote);
                ++start;
                while (start < end && input.charAt(start) != quote) {
                    result.append(input.charAt(start));
                    ++start;
                }
                if (start >= end) continue;
                result.append(quote);
                ++start;
                continue;
            }
            token.append(c);
            ++start;
        }
        if (token.length() > 0) {
            result.append(ClientUtils.escapeQueryChars((String)token.toString()));
        }
        return new ParseResult(result.toString(), start);
    }

    private static boolean isInParanthesis(String input) {
        return input.startsWith("(") && input.endsWith(")");
    }

    public static boolean isQuoted(String input) {
        return input.startsWith("\"") && input.endsWith("\"");
    }

    public static boolean isNullOrEmpty(String input) {
        return input == null || input.trim().length() == 0;
    }

    public static boolean isNullOrEmpty(String[] str) {
        return str == null || str.length == 0;
    }

    public static boolean isNullOrEmpty(Boolean str) {
        return str == null;
    }

    public static boolean isNullOrEmpty(Year startYear) {
        return startYear == null;
    }

    public static boolean isNullOrEmpty(LocalDate localDate) {
        return localDate == null;
    }

    public static String formatSolrYear(String fieldName, Year startYear, Year endYear) {
        if (startYear != null && endYear != null) {
            return String.format(fieldName, Utils.formatYear((Year)startYear), Utils.formatYear((Year)endYear));
        }
        if (startYear != null) {
            return String.format(fieldName, Utils.formatYear((Year)startYear), Utils.formatYear((Year)startYear));
        }
        if (endYear != null) {
            return String.format(fieldName, Utils.formatYear((Year)endYear), Utils.formatYear((Year)endYear));
        }
        return null;
    }

    public static String formatSolrYearRange(String fieldName, Year startYear, Year endYear) {
        if (startYear != null && endYear != null) {
            return String.format(fieldName, Utils.formatYear((Year)startYear), Utils.formatYear((Year)endYear));
        }
        if (startYear != null) {
            return String.format(fieldName, Utils.formatYear((Year)startYear), "*");
        }
        if (endYear != null) {
            return String.format(fieldName, "*", Utils.formatYear((Year)endYear));
        }
        return null;
    }

    public static String formatYear(Year year) {
        return year.toString();
    }

    public static String formatSolrDateRange(String fieldName, LocalDate fromDate, LocalDate toDate) {
        if (fromDate != null && toDate != null) {
            return String.format(fieldName, Utils.formatDate((LocalDate)fromDate), Utils.formatDate((LocalDate)toDate));
        }
        if (fromDate != null) {
            return String.format(fieldName, Utils.formatDate((LocalDate)fromDate), "*");
        }
        if (toDate != null) {
            return String.format(fieldName, "*", Utils.formatDate((LocalDate)toDate));
        }
        return null;
    }

    private static String formatDate(LocalDate localDate) {
        int hour = 12;
        int minute = 0;
        int second = 0;
        LocalDateTime localDateTime = localDate.atTime(hour, minute, second);
        ZonedDateTime zdt = localDateTime.atZone(ZoneOffset.UTC);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return zdt.format(formatter);
    }

    public static boolean hasOperator(String input) {
        String regex = "\\s+|(?=[()])|(?<=[()])";
        return Arrays.stream(input.split(regex)).anyMatch(token -> token.equals("AND") || token.equals("OR") || token.equals("NOT"));
    }

    public static String validateAndClean(String input) {
        System.out.println("Validate and clean: " + input);
        if (!Utils.isNullOrEmpty((String)input) && Utils.isValidQuoteFormat((String)input) && Utils.isValidParentheses((String)input) && Utils.areOperatorsValid((String)input)) {
            return Utils.cleanKeywords((String)input);
        }
        throw new SyntaxErrorException("Syntax Error.");
    }

    public static String validateAndClean(Boolean input) {
        if (!Utils.isNullOrEmpty((Boolean)input)) {
            return Boolean.toString(input);
        }
        throw new SyntaxErrorException("Syntax Error.");
    }

    public static List<String> splitInput(String input) {
        if (!Utils.isNullOrEmpty((String)input)) {
            ArrayList<String> tokens = new ArrayList<String>();
            Pattern pattern = Pattern.compile("\"[^\"]*\"|\\S+");
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                tokens.add(matcher.group());
            }
            return tokens;
        }
        return null;
    }

    public static List<String> newSplit(String input) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        boolean insideQuotes = false;
        boolean insideParenthesis = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (insideQuotes) {
                currentToken.append(ch);
                if (ch != quoteChar) continue;
                insideQuotes = false;
                tokens.add(currentToken.toString());
                currentToken.setLength(0);
                continue;
            }
            if (insideParenthesis) {
                currentToken.append(ch);
                if (ch != ')') continue;
                insideParenthesis = false;
                tokens.add(currentToken.toString());
                currentToken.setLength(0);
                continue;
            }
            if (ch == '\"') {
                if (currentToken.length() > 0) {
                    tokens.add(currentToken.toString());
                    currentToken.setLength(0);
                }
                insideQuotes = true;
                quoteChar = ch;
                currentToken.append(ch);
                continue;
            }
            if (ch == '(') {
                if (currentToken.length() > 0) {
                    tokens.add(currentToken.toString());
                    currentToken.setLength(0);
                }
                insideParenthesis = true;
                currentToken.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (currentToken.length() <= 0) continue;
                tokens.add(currentToken.toString());
                currentToken.setLength(0);
                continue;
            }
            currentToken.append(ch);
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }
        return tokens;
    }

    public static boolean isValidQuoteFormat(String input) throws SyntaxErrorException {
        Stack<Character> stack = new Stack<Character>();
        char[] chars = input.toCharArray();
        boolean isEscaped = false;
        for (char ch : chars) {
            if (ch == '\\') {
                isEscaped = !isEscaped;
                continue;
            }
            if (ch == '\"' && !isEscaped) {
                if (stack.isEmpty() || ((Character)stack.peek()).charValue() != ch) {
                    stack.push(Character.valueOf(ch));
                    continue;
                }
                stack.pop();
                continue;
            }
            isEscaped = false;
        }
        if (stack.isEmpty()) {
            return true;
        }
        throw new SyntaxErrorException("Syntax error. Invalid quotes.");
    }

    public static boolean isValidParentheses(String input) throws SyntaxErrorException {
        log.info("Paranthesis validation...");
        if (input == null || input.isEmpty()) {
            return true;
        }
        int parenthesesCount = 0;
        boolean inQuotes = false;
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (currentChar == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (inQuotes) continue;
            if (currentChar == '(') {
                ++parenthesesCount;
                continue;
            }
            if (currentChar != ')' || --parenthesesCount >= 0) continue;
            return false;
        }
        if (parenthesesCount == 0) {
            return true;
        }
        throw new SyntaxErrorException("Syntax error. Invalid parentheses.");
    }

    public static boolean areOperatorsValid(String input) throws SyntaxErrorException {
        List tokens = Utils.splitInput((String)input);
        for (int i = 0; i < tokens.size(); ++i) {
            String token = ((String)tokens.get(i)).toLowerCase();
            if (!(token.equals("and") || token.equals("or") ? i == 0 || i == tokens.size() - 1 || ((String)tokens.get(i + 1)).equalsIgnoreCase("and") || ((String)tokens.get(i + 1)).equalsIgnoreCase("or") : token.equals("not") && (i == tokens.size() - 1 || ((String)tokens.get(i + 1)).equalsIgnoreCase("and") && !((String)tokens.get(i - 1)).equalsIgnoreCase("and") || ((String)tokens.get(i + 1)).equalsIgnoreCase("or") || ((String)tokens.get(i + 1)).equalsIgnoreCase("not")))) continue;
            throw new SyntaxErrorException("Invalid syntax. Operators mismatched.");
        }
        return true;
    }

    public static String escapeAndJoin(String[] tokens, String operator) {
        tokens = (String[])Arrays.stream(tokens).map(String::trim).filter(s -> !s.isEmpty()).map(s -> {
            System.out.println("s -> " + s);
            s = Utils.validateAndClean((String)s);
            return s.startsWith("NOT") ? "* " + s : s;
        }).toArray(String[]::new);
        System.out.println("returning " + String.join((CharSequence)(" " + operator + " "), tokens));
        return String.join((CharSequence)(" " + operator + " "), tokens);
    }

    public static void main(String[] args) {
        System.out.println("Hello katerina ->" + Utils.validateAndClean((String)"Hello katerina"));
        System.out.println("Hello \"katerina ->" + Utils.validateAndClean((String)"Hello \"katerina"));
        System.out.println("Hello \\\"katerina ->" + Utils.validateAndClean((String)"Hello \\\"katerina"));
        System.out.println("Hello \"katerina\" ->" + Utils.validateAndClean((String)"Hello \"katerina\""));
        System.out.println("\"Hello katerina\" -> " + Utils.validateAndClean((String)"\"Hello katerina\""));
        System.out.println("Hello katerina " + Utils.isValidQuoteFormat((String)"Hello katerina"));
        System.out.println("Hello \"katerina " + Utils.isValidQuoteFormat((String)"Hello \"katerina"));
        System.out.println("Hello \\\"katerina " + Utils.isValidQuoteFormat((String)"Hello \\\"katerina"));
        System.out.println("Hello \"katerina\" " + Utils.isValidQuoteFormat((String)"Hello \"katerina\""));
        System.out.println("\"Hello katerina\"" + Utils.isValidQuoteFormat((String)"\"Hello katerina\""));
        System.out.println("Hello katerina ->" + Utils.isValidParentheses((String)"Hello katerina"));
        System.out.println("Hello (katerina) ->" + Utils.isValidParentheses((String)"Hello (katerina)"));
        System.out.println("Hello ((katerina) ->" + Utils.isValidParentheses((String)"Hello ((katerina)"));
        System.out.println("Hello katerina) ->" + Utils.isValidParentheses((String)"Hello katerina)"));
        System.out.println("\"Hello (((katerina\" -> " + Utils.isValidParentheses((String)"\"Hello (((katerina\""));
        System.out.println("Hello katerina ->" + Utils.validateAndClean((String)"Hello katerina") + "\n");
        System.out.println("Hello (katerina) ->" + Utils.validateAndClean((String)"Hello (katerina)") + "\n");
        System.out.println("Hello ((katerina) ->" + Utils.validateAndClean((String)"Hello ((katerina)") + "\n");
        System.out.println("Hello katerina) ->" + Utils.validateAndClean((String)"Hello katerina)") + "\n");
        System.out.println("\"Hello\" \"(((katerina\" -> " + Utils.validateAndClean((String)"\"Hello\" \"(((katerina\""));
        System.out.println(">>>\n" + String.valueOf(Utils.splitInput((String)"\"Hello\" my name id kayekkdldld \"(((katerina\" \"but who cares\" ")));
        System.out.println(Utils.cleanKeywords((String)"\"not undefined\""));
    }
}

