/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.response;

import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.response.CustomSolrHeader;
import eu.dnetlib.mappers.response.CustomSolrHeaderMapper;
import eu.dnetlib.solr.BasicSolrQuery;
import eu.dnetlib.solr.CustomSolrParams;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.springframework.stereotype.Component;

@Component
public class CustomSolrHeaderMapperImpl
implements CustomSolrHeaderMapper {
    public CustomSolrHeader toSearchHeader(QueryResponse queryResponse, int page, int size) {
        if (queryResponse == null) {
            return null;
        }
        CustomSolrHeader customSolrHeader = new CustomSolrHeader();
        if (queryResponse != null) {
            customSolrHeader.setTotal(this.queryResponseResultsNumFound(queryResponse));
            customSolrHeader.setCursorMark(queryResponse.getNextCursorMark());
        }
        customSolrHeader.setPage(page);
        customSolrHeader.setSize(size);
        customSolrHeader.setQuery("query");
        return customSolrHeader;
    }

    public CustomSolrHeader toSearchHeader(QueryResponse queryResponse, EntityRequest entityRequest) {
        if (queryResponse == null && entityRequest == null) {
            return null;
        }
        CustomSolrHeader customSolrHeader = new CustomSolrHeader();
        if (queryResponse != null) {
            customSolrHeader.setTotal(this.queryResponseResultsNumFound(queryResponse));
        }
        if (entityRequest != null) {
            if (entityRequest.getPage() != null) {
                customSolrHeader.setPage(entityRequest.getPage().intValue());
            }
            if (entityRequest.getSize() != null) {
                customSolrHeader.setSize(entityRequest.getSize().intValue());
            }
            customSolrHeader.setCursorMark(entityRequest.getCursorMark());
        }
        customSolrHeader.setQuery(this.mapDebugQuery(queryResponse));
        return customSolrHeader;
    }

    public CustomSolrHeader toSearchHeader(QueryResponse queryResponse, EntityRequest entityRequest, CustomSolrParams customSolrParams) {
        if (queryResponse == null && entityRequest == null && customSolrParams == null) {
            return null;
        }
        CustomSolrHeader customSolrHeader = new CustomSolrHeader();
        if (queryResponse != null) {
            customSolrHeader.setTotal(this.queryResponseResultsNumFound(queryResponse));
            customSolrHeader.setCursorMark(queryResponse.getNextCursorMark());
        }
        if (entityRequest != null) {
            if (entityRequest.getPage() != null) {
                customSolrHeader.setPage(entityRequest.getPage().intValue());
            }
            if (entityRequest.getSize() != null) {
                customSolrHeader.setSize(entityRequest.getSize().intValue());
            }
        }
        if (customSolrParams != null) {
            List list1;
            List fq;
            customSolrHeader.setQuery(this.customSolrParamsBasicSolrQueryQuery(customSolrParams));
            List list = fq = this.customSolrParamsBasicSolrQueryFq(customSolrParams);
            if (list != null) {
                customSolrHeader.setFq(new ArrayList(list));
            }
            if ((list1 = customSolrParams.getFacetFields()) != null) {
                customSolrHeader.setFacetField(new ArrayList(list1));
            }
        }
        customSolrHeader.setDebugQuery(this.mapDebugQuery(queryResponse));
        customSolrHeader.setDebugFq(this.mapDebugFq(queryResponse));
        return customSolrHeader;
    }

    private long queryResponseResultsNumFound(QueryResponse queryResponse) {
        if (queryResponse == null) {
            return 0L;
        }
        SolrDocumentList results = queryResponse.getResults();
        if (results == null) {
            return 0L;
        }
        long numFound = results.getNumFound();
        return numFound;
    }

    private String customSolrParamsBasicSolrQueryQuery(CustomSolrParams customSolrParams) {
        if (customSolrParams == null) {
            return null;
        }
        BasicSolrQuery basicSolrQuery = customSolrParams.getBasicSolrQuery();
        if (basicSolrQuery == null) {
            return null;
        }
        String query = basicSolrQuery.getQuery();
        if (query == null) {
            return null;
        }
        return query;
    }

    private List<String> customSolrParamsBasicSolrQueryFq(CustomSolrParams customSolrParams) {
        if (customSolrParams == null) {
            return null;
        }
        BasicSolrQuery basicSolrQuery = customSolrParams.getBasicSolrQuery();
        if (basicSolrQuery == null) {
            return null;
        }
        List fq = basicSolrQuery.getFq();
        if (fq == null) {
            return null;
        }
        return fq;
    }
}

