/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.request;

import eu.dnetlib.dto.request.DatasourceRequest;
import eu.dnetlib.exception.SyntaxErrorException;
import eu.dnetlib.mappers.Utils;
import eu.dnetlib.mappers.solr.SolrQueryMapper;
import eu.dnetlib.solr.BasicSolrQuery;
import eu.dnetlib.solr.SortParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel="spring")
public interface DatasourceRequestMapper {
    public static final Map<String, String> solrFieldMapping = SolrQueryMapper.dataSourceFieldMapping;
    public static final Map<String, String> idFieldMapping = SolrQueryMapper.dataSourceIdFieldMapping;
    public static final List<String> defaultFq = SolrQueryMapper.dataSourceDefaultFqMapping;
    public static final Map<String, String> sortFieldMapping = SolrQueryMapper.dataSourceSortMapping;
    public static final DatasourceRequestMapper INSTANCE = (DatasourceRequestMapper)Mappers.getMapper(DatasourceRequestMapper.class);

    @Mappings(value={@Mapping(target="query", expression="java( extractQuery(datasourceRequest) )"), @Mapping(target="fq", expression="java( extractFq(datasourceRequest) )")})
    public BasicSolrQuery toBasicSolrQuery(DatasourceRequest var1);

    @Mappings(value={@Mapping(target="query", expression="java( extractIdQuery(datasourceRequest) )"), @Mapping(target="fq", expression="java( extractFq(datasourceRequest) )")})
    public BasicSolrQuery toBasicIdSolrQuery(DatasourceRequest var1);

    default public String extractQuery(DatasourceRequest datasourceRequest) {
        ArrayList<String> qList = new ArrayList<String>();
        if (!Utils.isNullOrEmpty((String)datasourceRequest.getSearch())) {
            qList.add(String.format((String)solrFieldMapping.get("search"), Utils.validateAndClean((String)datasourceRequest.getSearch())));
        } else {
            qList.add(String.format((String)solrFieldMapping.get("search"), "*:*"));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getOfficialName())) {
            qList.add(String.format((String)solrFieldMapping.get("officialName"), Utils.escapeAndJoin((String[])datasourceRequest.getOfficialName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getEnglishName())) {
            qList.add(String.format((String)solrFieldMapping.get("englishName"), Utils.escapeAndJoin((String[])datasourceRequest.getEnglishName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getRelOrganizationName())) {
            qList.add(String.format((String)solrFieldMapping.get("relOrganizationName"), Utils.escapeAndJoin((String[])datasourceRequest.getRelOrganizationName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getRelOrganizationShortName())) {
            qList.add(String.format((String)solrFieldMapping.get("relOrganizationShortName"), Utils.escapeAndJoin((String[])datasourceRequest.getRelOrganizationShortName(), (String)"OR")));
        }
        return String.join((CharSequence)" AND ", qList);
    }

    default public List<String> extractFq(DatasourceRequest datasourceRequest) {
        ArrayList<String> fqList = new ArrayList<String>();
        fqList.addAll(defaultFq);
        if (!Utils.isNullOrEmpty((String)datasourceRequest.getObjIdentifier())) {
            fqList.add(String.format((String)solrFieldMapping.get("objIdentifier"), Utils.validateAndClean((String)datasourceRequest.getObjIdentifier())));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getPid())) {
            fqList.add(String.format((String)solrFieldMapping.get("pid"), Utils.escapeAndJoin((String[])datasourceRequest.getPid(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getSubjects())) {
            fqList.add(String.format((String)solrFieldMapping.get("subjects"), Utils.escapeAndJoin((String[])datasourceRequest.getSubjects(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getDataSourceTypeName())) {
            fqList.add(String.format((String)solrFieldMapping.get("dataSourceTypeName"), Utils.escapeAndJoin((String[])datasourceRequest.getDataSourceTypeName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getCollectedFromName())) {
            fqList.add(String.format((String)solrFieldMapping.get("collectedFromName"), Utils.escapeAndJoin((String[])datasourceRequest.getCollectedFromName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getEoscDatasourceType())) {
            fqList.add(String.format((String)solrFieldMapping.get("eoscdatasourcetype"), Utils.escapeAndJoin((String[])datasourceRequest.getEoscDatasourceType(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getOdLanguages())) {
            fqList.add(String.format((String)solrFieldMapping.get("odLanguages"), Utils.escapeAndJoin((String[])datasourceRequest.getOdLanguages(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getCompatibilityId())) {
            fqList.add(String.format((String)solrFieldMapping.get("compatibilityId"), Utils.escapeAndJoin((String[])datasourceRequest.getCompatibilityId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getCompatibilityName())) {
            fqList.add(String.format((String)solrFieldMapping.get("compatibilityName"), Utils.escapeAndJoin((String[])datasourceRequest.getCompatibilityName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getContentTypes())) {
            fqList.add(String.format((String)solrFieldMapping.get("contentTypes"), Utils.escapeAndJoin((String[])datasourceRequest.getContentTypes(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getCountry())) {
            fqList.add(String.format((String)solrFieldMapping.get("country"), Utils.escapeAndJoin((String[])datasourceRequest.getCountry(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((Boolean)datasourceRequest.getThematic())) {
            fqList.add(String.format((String)solrFieldMapping.get("thematic"), Utils.validateAndClean((Boolean)datasourceRequest.getThematic())));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getJurisdiction())) {
            fqList.add(String.format((String)solrFieldMapping.get("jurisdiction"), Utils.escapeAndJoin((String[])datasourceRequest.getJurisdiction(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getEoscType())) {
            fqList.add(String.format((String)solrFieldMapping.get("eoscType"), Utils.escapeAndJoin((String[])datasourceRequest.getEoscType(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getRelOrganizationId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relOrganizationId"), Utils.escapeAndJoin((String[])datasourceRequest.getRelOrganizationId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getRelCommunityId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCommunityId"), Utils.escapeAndJoin((String[])datasourceRequest.getRelCommunityId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])datasourceRequest.getRelCollectedFromDatasourceId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCollectedFromDatasourceId"), Utils.escapeAndJoin((String[])datasourceRequest.getRelCollectedFromDatasourceId(), (String)"OR")));
        }
        return fqList;
    }

    default public String extractIdQuery(DatasourceRequest datasourceRequest) {
        ArrayList<String> idList = new ArrayList<String>();
        if (datasourceRequest.getId().length > 1) {
            throw new SyntaxErrorException("Illegal multiple value parameter. Id parameter must be unique.");
        }
        idList.add(String.format((String)idFieldMapping.get("id"), Utils.escapeAndJoin((String[])datasourceRequest.getId(), (String)"OR")));
        System.out.println("ID LIST: " + String.valueOf(idList));
        return String.join((CharSequence)" OR ", idList);
    }

    default public SortParam extractSort(DatasourceRequest datasourceRequest) {
        SortParam sortParam = new SortParam();
        String[] sortParams = datasourceRequest.getSortBy().split(" ");
        sortParam.getSort().put((String)sortFieldMapping.get(sortParams[0]), sortParams[1]);
        return sortParam;
    }

    default public List<SortParam> extractSortParams(DatasourceRequest datasourceRequest) {
        String[] sortByPairs;
        ArrayList<SortParam> sortParamList = new ArrayList<SortParam>();
        for (String pair : sortByPairs = datasourceRequest.getSortBy().split(",")) {
            SortParam sortParam = new SortParam();
            String[] parts = pair.trim().split("\\s+");
            String field = parts[0];
            sortParam.getSort().put((String)sortFieldMapping.get(parts[0]), parts[1]);
            sortParamList.add(sortParam);
        }
        return sortParamList;
    }
}

