/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.controllers;

import eu.dnetlib.controllers.EntityController;
import eu.dnetlib.dhp.schema.solr.Person;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.PersonRequest;
import eu.dnetlib.exception.DocumentNotFoundException;
import eu.dnetlib.mappers.response.CustomSolrResponseMapper;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.services.PersonService;
import eu.dnetlib.solr.CustomSolrParams;
import java.io.IOException;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/persons"})
public class PersonController
extends EntityController {
    @Autowired
    PersonService personService;
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    @Autowired
    SolrRepository solrRepository;
    @Autowired
    CustomSolrResponseMapper customSolrResponseMapper;

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public Person getById(@PathVariable String id) throws SolrServerException, IOException {
        PersonRequest personRequest = new PersonRequest();
        personRequest.setId(new String[]{id});
        return this.personService.getById(personRequest);
    }

    @GetMapping(value={"/orcid/{id}"}, produces={"application/json"})
    public String getById(PersonRequest personRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomIdSolrParams((EntityRequest)personRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        if (queryResponse.getResults() != null && queryResponse.getResults().size() < 1 || queryResponse.getResults().isEmpty()) {
            throw new DocumentNotFoundException("Person with orcid: " + String.valueOf(personRequest.getId()) + " not found.");
        }
        return this.customSolrResponseMapper.toSingleEntityResponse(queryResponse).getRecord();
    }
}

