/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.request;

import eu.dnetlib.dto.request.OrganizationRequest;
import eu.dnetlib.exception.SyntaxErrorException;
import eu.dnetlib.mappers.Utils;
import eu.dnetlib.mappers.solr.SolrQueryMapper;
import eu.dnetlib.solr.BasicSolrQuery;
import eu.dnetlib.solr.SortParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel="spring")
public interface OrganizationRequestMapper {
    public static final Map<String, String> solrFieldMapping = SolrQueryMapper.organizationRequestMapping;
    public static final List<String> defaultFq = SolrQueryMapper.organizationDefaultFqMapping;
    public static final Map<String, String> idFieldMapping = SolrQueryMapper.organizationIdRequestMapping;
    public static final Map<String, String> sortFieldMapping = SolrQueryMapper.organizationSortMapping;
    public static final OrganizationRequestMapper INSTANCE = (OrganizationRequestMapper)Mappers.getMapper(OrganizationRequestMapper.class);

    @Mappings(value={@Mapping(target="query", expression="java(extractQuery(organizationRequest))"), @Mapping(target="fq", expression="java(extractFq(organizationRequest))")})
    public BasicSolrQuery toBasicSolrQuery(OrganizationRequest var1);

    @Mappings(value={@Mapping(target="query", expression="java( extractIdQuery(organizationRequest) )"), @Mapping(target="fq", expression="java( extractFq(organizationRequest) )")})
    public BasicSolrQuery toBasicIdSolrQuery(OrganizationRequest var1);

    default public String extractQuery(OrganizationRequest organizationRequest) {
        ArrayList<String> qList = new ArrayList<String>();
        if (!Utils.isNullOrEmpty((String)organizationRequest.getSearch())) {
            qList.add(String.format((String)solrFieldMapping.get("search"), Utils.validateAndClean((String)organizationRequest.getSearch())));
        } else {
            qList.add(String.format((String)solrFieldMapping.get("search"), "*:*"));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getLegalName())) {
            qList.add(String.format((String)solrFieldMapping.get("legalName"), Utils.escapeAndJoin((String[])organizationRequest.getLegalName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getLegalShortName())) {
            qList.add(String.format((String)solrFieldMapping.get("legalShortName"), Utils.escapeAndJoin((String[])organizationRequest.getLegalShortName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getFullOrShortName())) {
            qList.add(String.format((String)solrFieldMapping.get("fullOrShortMapping"), Utils.escapeAndJoin((String[])organizationRequest.getFullOrShortName(), (String)"OR"), Utils.escapeAndJoin((String[])organizationRequest.getFullOrShortName(), (String)"OR")));
        }
        return String.join((CharSequence)" AND ", qList);
    }

    default public String extractIdQuery(OrganizationRequest organizationRequest) {
        ArrayList<String> idList = new ArrayList<String>();
        if (organizationRequest.getId().length > 1) {
            throw new SyntaxErrorException("Illegal multiple value parameter. Id parameter must be unique.");
        }
        idList.add(String.format((String)idFieldMapping.get("id"), Utils.escapeAndJoin((String[])organizationRequest.getId(), (String)"OR")));
        idList.add(String.format((String)idFieldMapping.get("dupid"), Utils.validateAndClean((String)organizationRequest.getId()[0].trim())));
        return String.join((CharSequence)" OR ", idList);
    }

    default public List<String> extractFq(OrganizationRequest organizationRequest) {
        ArrayList<String> fqList = new ArrayList<String>();
        fqList.addAll(defaultFq);
        if (!Utils.isNullOrEmpty((String)organizationRequest.getObjIdentifier())) {
            fqList.add(String.format((String)solrFieldMapping.get("objIdentifier"), Utils.validateAndClean((String)organizationRequest.getObjIdentifier())));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getPid())) {
            fqList.add(String.format((String)solrFieldMapping.get("pid"), Utils.escapeAndJoin((String[])organizationRequest.getPid(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getPidClass())) {
            fqList.add(String.format((String)solrFieldMapping.get("pidClass"), Utils.escapeAndJoin((String[])organizationRequest.getPidClass(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getCountryCode())) {
            fqList.add(String.format((String)solrFieldMapping.get("countryCode"), Utils.escapeAndJoin((String[])organizationRequest.getCountryCode(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getCountry())) {
            fqList.add(String.format((String)solrFieldMapping.get("countryCode"), Utils.escapeAndJoin((String[])organizationRequest.getCountry(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getRelResultId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relResultId"), Utils.escapeAndJoin((String[])organizationRequest.getRelResultId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getRelCommunityId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCommunityId"), Utils.escapeAndJoin((String[])organizationRequest.getRelCommunityId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])organizationRequest.getRelCollectedFromDatasourceId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCollectedFromDatasourceId"), Utils.escapeAndJoin((String[])organizationRequest.getRelCollectedFromDatasourceId(), (String)"OR")));
        }
        return fqList;
    }

    default public SortParam extractSort(OrganizationRequest organizationRequest) {
        SortParam sortParam = new SortParam();
        String[] sortParams = organizationRequest.getSortBy().split(" ");
        System.out.println("sort param 0 " + sortParams[0]);
        System.out.println("sort param 1 " + sortParams[1]);
        sortParam.getSort().put((String)sortFieldMapping.get(sortParams[0]), sortParams[1]);
        this.extractSortParams(organizationRequest);
        return sortParam;
    }

    default public List<SortParam> extractSortParams(OrganizationRequest organizationRequest) {
        String[] sortByPairs;
        ArrayList<SortParam> sortParamList = new ArrayList<SortParam>();
        for (String pair : sortByPairs = organizationRequest.getSortBy().split(",")) {
            SortParam sortParam = new SortParam();
            String[] parts = pair.trim().split("\\s+");
            String field = parts[0];
            sortParam.getSort().put((String)sortFieldMapping.get(parts[0]), parts[1]);
            sortParamList.add(sortParam);
        }
        return sortParamList;
    }
}

