/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.solr;

import eu.dnetlib.config.properties.SolrProperties;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class SolrConnectionManager {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private final SolrProperties solrProperties;
    public SolrClient solrClient;

    public SolrConnectionManager(SolrProperties _solrProperties) throws SolrServerException, IOException {
        this.solrProperties = _solrProperties;
        this.initSolrClient();
    }

    private void initSolrClient() throws SolrServerException, IOException {
        List<String> zkHosts = Arrays.asList(this.solrProperties.getZkHosts());
        this.log.info("Creating Solr client - Zookeeper instances: " + String.valueOf(zkHosts));
        this.log.info("Creating Solr client - Collection: " + this.solrProperties.collection);
        this.solrClient = ((CloudSolrClient.Builder)((CloudSolrClient.Builder)new CloudSolrClient.Builder(zkHosts, Optional.empty()).withConnectionTimeout(3000)).withSocketTimeout(30000)).build();
        ((CloudSolrClient)this.solrClient).setDefaultCollection(this.solrProperties.collection);
        this.log.info("Creating Solr client - Ping response: " + this.solrClient.ping().toString());
    }

    @PreDestroy
    private void closeClient() throws IOException {
        this.log.info("Closing Solr client");
        if (this.solrClient != null) {
            this.solrClient.close();
        }
    }
}

