/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.services;

import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.OrganizationRequest;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.exception.DocumentNotFoundException;
import eu.dnetlib.mappers.response.CustomSolrResponseMapper;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.solr.CustomSolrParams;
import java.io.IOException;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrganizationService {
    private static final Logger log = LoggerFactory.getLogger(OrganizationService.class);
    @Autowired
    SolrRepository solrRepository;
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    @Autowired
    CustomSolrResponseMapper customSolrResponseMapper;

    public String getById(OrganizationRequest organizationRequest) throws SolrServerException, IOException {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomIdSolrParams((EntityRequest)organizationRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        if (queryResponse.getResults() != null && queryResponse.getResults().size() < 1 || queryResponse.getResults().isEmpty()) {
            throw new DocumentNotFoundException("Organization with id: " + organizationRequest.getId()[0] + " not found.");
        }
        return this.customSolrResponseMapper.toSingleEntityResponse(queryResponse).getRecord();
    }

    public CustomSolrResponse search(OrganizationRequest organizationRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)organizationRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)organizationRequest, customSolrParams);
    }

    public CustomSolrResponse facetSearch(OrganizationRequest organizationRequest, FacetRequest facetRequest, Integer facetlimit) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)organizationRequest, facetRequest, facetlimit);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)organizationRequest, customSolrParams);
    }
}

