/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.services;

import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.ResearchProductRequest;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.exception.DocumentNotFoundException;
import eu.dnetlib.mappers.request.ResearchProductRequestMapper;
import eu.dnetlib.mappers.response.CustomSolrResponseMapper;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.solr.CustomSolrParams;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResearchProductService {
    @Autowired
    SolrRepository solrRepository;
    @Autowired
    ResearchProductRequestMapper mapper;
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    @Autowired
    CustomSolrResponseMapper customSolrResponseMapper;

    public String getById(ResearchProductRequest researchProductRequest) throws SolrServerException, IOException {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomIdSolrParams((EntityRequest)researchProductRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        if (queryResponse.getResults() != null && queryResponse.getResults().size() < 1 || queryResponse.getResults().isEmpty()) {
            throw new DocumentNotFoundException("Datasource with id: " + researchProductRequest.getId()[0] + " not found.");
        }
        return this.customSolrResponseMapper.toSingleEntityResponse(queryResponse).getRecord();
    }

    public CustomSolrResponse search(ResearchProductRequest researchProductRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)researchProductRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)researchProductRequest, customSolrParams);
    }

    public CustomSolrResponse searchOr(ResearchProductRequest researchProductRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrOrParams((EntityRequest)researchProductRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)researchProductRequest, customSolrParams);
    }

    public CustomSolrResponse facetSearch(ResearchProductRequest researchProductRequest, FacetRequest facetRequest, Integer facetLimit) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)researchProductRequest, facetRequest, facetLimit);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        System.out.println(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)researchProductRequest, customSolrParams);
    }

    public CustomSolrResponse internalFacetSearch(ResearchProductRequest researchProductRequest, FacetRequest facetRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParamsForBrowseAll((EntityRequest)researchProductRequest, facetRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        System.out.println(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)researchProductRequest, customSolrParams);
    }

    public CustomSolrResponse cursorSearch(ResearchProductRequest researchProductRequest) {
        boolean hasMoreResults;
        CustomSolrResponse customSolrResponse = null;
        String cursorMark = "*";
        int streamedRows = 0;
        int total = 0;
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomCursorSolrParams((EntityRequest)researchProductRequest);
        do {
            QueryResponse queryResponse = this.solrRepository.cursorQuery(customSolrParams);
            SolrDocumentList docs = queryResponse.getResults();
            if (streamedRows == 0) {
                customSolrResponse = this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)researchProductRequest, customSolrParams);
                total = Long.valueOf(customSolrResponse.getHeader().getTotal()).intValue();
            } else {
                customSolrResponse.getBody().getResults().addAll(this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)researchProductRequest, customSolrParams).getBody().getResults());
            }
            ++streamedRows;
            String nextCursorMark = queryResponse.getNextCursorMark();
            if (cursorMark.equals(nextCursorMark)) break;
            hasMoreResults = nextCursorMark != cursorMark;
            cursorMark = nextCursorMark;
            customSolrParams.setCursorMark(cursorMark);
        } while (streamedRows < total && streamedRows < 2000 && hasMoreResults);
        return customSolrResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cursorSearchStream(ResearchProductRequest researchProductRequest, OutputStream outputStream) {
        CustomSolrParams initialParams = this.customSolrParamsMapper.toCustomCursorSolrParams((EntityRequest)researchProductRequest);
        String cursorMark = "*";
        try {
            while (true) {
                QueryResponse queryResponse = this.solrRepository.cursorQuery(initialParams);
                SolrDocumentList docs = queryResponse.getResults();
                for (SolrDocument doc : docs) {
                    String json = (String)doc.get((Object)"__json");
                    outputStream.write(json.getBytes());
                    outputStream.flush();
                }
                String nextCursorMark = queryResponse.getNextCursorMark();
                if (cursorMark.equals(nextCursorMark)) {
                    break;
                }
                cursorMark = nextCursorMark;
            }
        }
        catch (IOException e) {
            System.out.println("Error during Solr cursor search");
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                System.out.println("Error closing OutputStream");
            }
        }
    }
}

