/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.csv;

import eu.dnetlib.dhp.schema.solr.Author;
import eu.dnetlib.dhp.schema.solr.Pid;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.helpers.csv.ResearchProductCsv;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface ResearchProductCsvMapper {
    @Mappings(value={@Mapping(target="researchProduct", source="result.resulttype"), @Mapping(target="title", source="result.maintitle"), @Mapping(target="authors", expression="java(extractAuthor(solrRecord))"), @Mapping(target="publicationYear", source="result.publicationdate"), @Mapping(target="doi", expression="java(extractDoi(solrRecord))"), @Mapping(target="type", source="result.resulttype"), @Mapping(target="peerReviewed", expression="java(extractPeerReviewed(solrRecord))"), @Mapping(target="diamondJournal", source="result.isInDiamondJournal"), @Mapping(target="journal", source="result.journal.name"), @Mapping(target="downloadFrom", expression="java(extractDownloadFrom(solrRecord))"), @Mapping(target="publiclyFunded", source="result.publiclyFunded"), @Mapping(target="funder_Project", expression="java(extractFunder(solrRecord))"), @Mapping(target="access", source="result.bestaccessright.label"), @Mapping(target="green", source="result.isGreen"), @Mapping(target="oaColour", source="result.openAccessColor")})
    public ResearchProductCsv toResearchProductCsv(SolrRecord var1);

    @Mappings(value={@Mapping(target="researchProduct", source="result.resulttype"), @Mapping(target="title", source="result.maintitle"), @Mapping(target="authors", expression="java(extractAuthor(solrRecord))"), @Mapping(target="publicationYear", source="result.publicationdate"), @Mapping(target="doi", expression="java(extractDoi(solrRecord))"), @Mapping(target="type", source="result.resulttype"), @Mapping(target="peerReviewed", expression="java(extractPeerReviewed(solrRecord))"), @Mapping(target="diamondJournal", source="result.isInDiamondJournal"), @Mapping(target="journal", source="result.journal.name"), @Mapping(target="downloadFrom", expression="java(extractDownloadFrom(solrRecord))"), @Mapping(target="publiclyFunded", source="result.publiclyFunded"), @Mapping(target="access", source="result.bestaccessright.label"), @Mapping(target="green", source="result.isGreen"), @Mapping(target="oaColour", source="result.openAccessColor")})
    public ResearchProductCsv toSimpleResearchProductCsv(SolrRecord var1);

    default public List<String> extractAuthor(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getResult().getAuthor()).stream().flatMap(Collection::stream).map(Author::getFullname).filter(Objects::nonNull).collect(Collectors.toList());
    }

    default public String extractFunder(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getLinks()).stream().flatMap(Collection::stream).filter(relatedRecord -> "isProducedBy".equalsIgnoreCase(relatedRecord.getHeader().getRelationClass())).map(relatedRecord -> {
            Object funderString = Optional.ofNullable(relatedRecord.getFunding()).map(funding -> Optional.ofNullable(funding.getFunder()).map(funder -> Optional.ofNullable(funder.getShortname()).orElse(funder.getName())).orElse("")).orElse("");
            String projectString = Optional.ofNullable(relatedRecord.getAcronym()).orElseGet(() -> Optional.ofNullable(relatedRecord.getProjectTitle()).orElse("Unknown"));
            funderString = (String)funderString + "|" + projectString;
            String code = Optional.ofNullable(relatedRecord.getCode()).map(c -> "(" + c + ")").orElse("");
            return (String)funderString + code;
        }).collect(Collectors.joining(";"));
    }

    default public List<String> extractDoi(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getPid()).stream().flatMap(Collection::stream).filter(pid -> "doi".equalsIgnoreCase(pid.getTypeLabel())).map(Pid::getValue).collect(Collectors.toList());
    }

    default public String extractPeerReviewed(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getResult().getInstance()).stream().flatMap(Collection::stream).filter(instance -> "peerReviewed".equalsIgnoreCase(instance.getRefereed())).findFirst().map(instance -> "yes").orElse("no");
    }

    default public String extractDownloadFrom(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getResult().getInstance()).stream().flatMap(Collection::stream).filter(instance -> "OPEN".equalsIgnoreCase(instance.getAccessright().getLabel())).findFirst().map(instance -> Optional.ofNullable(instance.getUrl()).filter(urls -> !urls.isEmpty()).map(urls -> (String)urls.get(0)).orElse("")).orElseGet(() -> solrRecord.getResult().getInstance().stream().findFirst().map(instance -> Optional.ofNullable(instance.getUrl()).filter(urls -> !urls.isEmpty()).map(urls -> (String)urls.get(0)).orElse("")).orElse(""));
    }
}

