/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.services;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.dto.request.DatasourceRequest;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.OrganizationRequest;
import eu.dnetlib.dto.request.ProjectRequest;
import eu.dnetlib.dto.request.ResearchProductRequest;
import eu.dnetlib.dto.request.ServiceRequest;
import eu.dnetlib.dto.response.CustomSolrBody;
import eu.dnetlib.helpers.csv.CsvEntity;
import eu.dnetlib.helpers.csv.DatasourceCsv;
import eu.dnetlib.helpers.csv.OrganizationCsv;
import eu.dnetlib.helpers.csv.ProjectCsv;
import eu.dnetlib.helpers.csv.ResearchProductCsv;
import eu.dnetlib.helpers.csv.ResearchProductCsvConverter;
import eu.dnetlib.mappers.csv.DatasourceCsvMapper;
import eu.dnetlib.mappers.csv.OrganizationCsvMapper;
import eu.dnetlib.mappers.csv.ProjectCsvMapper;
import eu.dnetlib.mappers.csv.ResearchProductCsvMapper;
import eu.dnetlib.mappers.response.CustomSolrBodyMapper;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.solr.CustomSolrParams;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CsvDownloadService<T extends CsvEntity> {
    private static final Logger log = LoggerFactory.getLogger(CsvDownloadService.class);
    @Autowired
    OrganizationCsvMapper organizationCsvMapper;
    @Autowired
    DatasourceCsvMapper datasourceCsvMapper;
    @Autowired
    ProjectCsvMapper projectCsvMapper;
    @Autowired
    ResearchProductCsvMapper reseachProductCsvMapper;
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    @Autowired
    SolrRepository solrRepository;
    @Autowired
    CustomSolrBodyMapper customSolrBodyMapper;
    @Autowired
    ResearchProductCsvConverter researchProductCsvConverter;
    final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    final CsvMapper csvMapper = new CsvMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamCsv(EntityRequest entityRequest, OutputStream outputStream, boolean hasTitle) {
        CustomSolrParams initialParams = this.customSolrParamsMapper.toCustomCursorSolrParams(entityRequest);
        String cursorMark = "*";
        int streamedRows = 0;
        CsvSchema schema = this.getCsvSchema(entityRequest);
        ObjectWriter csvWriterRow = this.csvMapper.writer((FormatSchema)schema);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        ObjectWriter csvWriter = this.csvMapper.writer((FormatSchema)schema);
        try {
            if (hasTitle) {
                this.writeCsvHeaderRow(entityRequest, writer);
            }
            do {
                QueryResponse queryResponse = this.solrRepository.cursorQuery(initialParams);
                SolrDocumentList docs = queryResponse.getResults();
                for (SolrDocument doc : docs) {
                    this.writeCsvRow(entityRequest, doc, csvWriterRow, writer);
                    ++streamedRows;
                }
                String nextCursorMark = queryResponse.getNextCursorMark();
                if (cursorMark.equals(nextCursorMark)) {
                    break;
                }
                cursorMark = nextCursorMark;
                initialParams.setCursorMark(cursorMark);
            } while (streamedRows < 2000);
        }
        catch (IOException | ReflectiveOperationException e) {
            log.error("Error during Solr cursor search.", (Throwable)e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.error("Error closing OutputStream", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamSpecialCsv(EntityRequest entityRequest, OutputStream outputStream, boolean hasTitle) {
        CustomSolrParams initialParams = this.customSolrParamsMapper.toCustomCursorSolrParams(entityRequest);
        String cursorMark = "*";
        int streamedRows = 0;
        CsvSchema schema = this.getCsvSchema(entityRequest);
        ObjectWriter csvWriterRow = this.csvMapper.writer((FormatSchema)schema);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        ObjectWriter csvWriter = this.csvMapper.writer((FormatSchema)schema);
        try {
            if (hasTitle) {
                this.writeCsvHeaderRow(entityRequest, writer);
            }
            do {
                QueryResponse queryResponse = this.solrRepository.cursorQuery(initialParams);
                SolrDocumentList docs = queryResponse.getResults();
                CustomSolrBody solrBody = this.customSolrBodyMapper.toCustomSolrBody(queryResponse);
                List jsonResults = solrBody.getResults();
                for (String resultString : jsonResults) {
                    SolrRecord solrRecord = (SolrRecord)this.objectMapper.readValue(resultString, SolrRecord.class);
                    List flattenedProducts = this.researchProductCsvConverter.flattenProjects(solrRecord);
                    for (ResearchProductCsv csvEntity : flattenedProducts) {
                        String csvRow = csvWriterRow.writeValueAsString((Object)csvEntity);
                        writer.write(csvRow);
                        writer.flush();
                    }
                    ++streamedRows;
                }
                String nextCursorMark = queryResponse.getNextCursorMark();
                if (cursorMark.equals(nextCursorMark)) {
                    break;
                }
                cursorMark = nextCursorMark;
                initialParams.setCursorMark(cursorMark);
            } while (streamedRows < 2000);
        }
        catch (IOException | ReflectiveOperationException e) {
            log.error("Error during Solr cursor search", (Throwable)e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.error("Error closing OutputStream", (Throwable)e);
            }
        }
    }

    private void writeCsvRow(EntityRequest entityRequest, SolrDocument doc, ObjectWriter csvWriterRow, BufferedWriter writer) throws IOException {
        String json = (String)doc.get((Object)"__json");
        SolrRecord solrRecord = (SolrRecord)this.objectMapper.readValue(json, SolrRecord.class);
        String csvRow = this.convertSolrRecordToCsv(entityRequest, solrRecord, csvWriterRow);
        writer.write(csvRow);
        writer.flush();
    }

    private void writeCsvHeaderRow(EntityRequest entityRequest, BufferedWriter writer) throws ReflectiveOperationException, IOException {
        CsvSchema headerSchema = this.getCsvHeaderSchema(entityRequest);
        ObjectWriter csvWriterHeader = this.csvMapper.writer((FormatSchema)headerSchema);
        String headerRow = this.getHeaderRow(entityRequest);
        writer.write(headerRow);
        writer.newLine();
        writer.flush();
    }

    private CsvSchema getCsvSchema(EntityRequest entityRequest) {
        if (entityRequest instanceof ResearchProductRequest) {
            return this.csvMapper.schemaFor(ResearchProductCsv.class).withoutHeader();
        }
        if (entityRequest instanceof ProjectRequest) {
            return this.csvMapper.schemaFor(ProjectCsv.class).withoutHeader();
        }
        if (entityRequest instanceof DatasourceRequest || entityRequest instanceof ServiceRequest) {
            return this.csvMapper.schemaFor(DatasourceCsv.class).withoutHeader();
        }
        if (entityRequest instanceof OrganizationRequest) {
            return this.csvMapper.schemaFor(OrganizationCsv.class).withoutHeader();
        }
        throw new IllegalArgumentException("Unsupported EntityRequest type: " + entityRequest.getClass().getSimpleName());
    }

    private CsvSchema getCsvHeaderSchema(EntityRequest entityRequest) {
        if (entityRequest instanceof ResearchProductRequest) {
            return this.csvMapper.schemaFor(ResearchProductCsv.class).withoutHeader();
        }
        if (entityRequest instanceof ProjectRequest) {
            return this.csvMapper.schemaFor(ProjectCsv.class).withoutHeader();
        }
        if (entityRequest instanceof DatasourceRequest || entityRequest instanceof ServiceRequest) {
            return this.csvMapper.schemaFor(DatasourceCsv.class).withoutHeader();
        }
        if (entityRequest instanceof OrganizationRequest) {
            return this.csvMapper.schemaFor(OrganizationCsv.class).withoutHeader();
        }
        throw new IllegalArgumentException("Unsupported EntityRequest type: " + entityRequest.getClass().getSimpleName());
    }

    private String getHeaderRow(EntityRequest entityRequest) throws ReflectiveOperationException, JsonProcessingException {
        CsvSchema headerSchema = null;
        ObjectWriter csvWriterHeader = null;
        if (entityRequest instanceof ResearchProductRequest) {
            headerSchema = this.csvMapper.schemaFor(ResearchProductCsv.class).withHeader();
            csvWriterHeader = this.csvMapper.writer((FormatSchema)headerSchema);
            return csvWriterHeader.writeValueAsString(ResearchProductCsv.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).split(System.lineSeparator())[0];
        }
        if (entityRequest instanceof ProjectRequest) {
            headerSchema = this.csvMapper.schemaFor(ProjectCsv.class).withHeader();
            csvWriterHeader = this.csvMapper.writer((FormatSchema)headerSchema);
            return csvWriterHeader.writeValueAsString(ProjectCsv.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).split(System.lineSeparator())[0];
        }
        if (entityRequest instanceof DatasourceRequest || entityRequest instanceof ServiceRequest) {
            headerSchema = this.csvMapper.schemaFor(DatasourceCsv.class).withHeader();
            csvWriterHeader = this.csvMapper.writer((FormatSchema)headerSchema);
            return csvWriterHeader.writeValueAsString(DatasourceCsv.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).split(System.lineSeparator())[0];
        }
        if (entityRequest instanceof OrganizationRequest) {
            headerSchema = this.csvMapper.schemaFor(OrganizationCsv.class).withHeader();
            this.csvMapper.writer((FormatSchema)headerSchema);
        }
        throw new IllegalArgumentException("Unsupported EntityRequest type: " + entityRequest.getClass().getSimpleName());
    }

    private CsvEntity createEntityCsvInstance(EntityRequest entityRequest) throws ReflectiveOperationException {
        if (entityRequest instanceof ResearchProductRequest) {
            return (CsvEntity)ResearchProductCsv.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (entityRequest instanceof ProjectRequest) {
            return (CsvEntity)ProjectCsv.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (entityRequest instanceof DatasourceRequest || entityRequest instanceof ServiceRequest) {
            return (CsvEntity)DatasourceCsv.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (entityRequest instanceof OrganizationRequest) {
            return (CsvEntity)OrganizationCsv.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        throw new IllegalArgumentException("Unsupported EntityRequest type: " + entityRequest.getClass().getSimpleName());
    }

    private String convertSolrRecordToCsv(EntityRequest entityRequest, SolrRecord solrRecord, ObjectWriter csvWriterRow) throws JsonProcessingException {
        if (entityRequest instanceof ResearchProductRequest) {
            return csvWriterRow.writeValueAsString((Object)this.reseachProductCsvMapper.toResearchProductCsv(solrRecord));
        }
        if (entityRequest instanceof ProjectRequest) {
            return csvWriterRow.writeValueAsString((Object)this.projectCsvMapper.toProjectCsv(solrRecord));
        }
        if (entityRequest instanceof DatasourceRequest || entityRequest instanceof ServiceRequest) {
            return csvWriterRow.writeValueAsString((Object)this.datasourceCsvMapper.toDatasourceCsv(solrRecord));
        }
        if (entityRequest instanceof OrganizationRequest) {
            return csvWriterRow.writeValueAsString((Object)this.organizationCsvMapper.toOrganizationCsv(solrRecord));
        }
        throw new IllegalArgumentException("Unsupported EntityRequest type: " + entityRequest.getClass().getSimpleName());
    }
}

