/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repository;

import eu.dnetlib.mappers.solr.FacetFieldMapper;
import eu.dnetlib.solr.CustomSolrParams;
import eu.dnetlib.solr.SolrConnectionManager;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class SolrRepository {
    @Autowired
    private SolrConnectionManager solrConnectionManager;
    @Autowired
    FacetFieldMapper facetFieldMapper;
    private final Logger log = LogManager.getLogger(this.getClass());

    public QueryResponse query(CustomSolrParams customSolrParams) {
        SolrQuery solrQuery;
        long start = System.nanoTime();
        SolrQuery query = solrQuery = new SolrQuery();
        if (customSolrParams.getBasicSolrQuery() != null) {
            query.setQuery(customSolrParams.getBasicSolrQuery().getQuery());
        }
        if (customSolrParams.getBasicSolrQuery().getFq() != null) {
            customSolrParams.getBasicSolrQuery().getFq().stream().forEach(xva$0 -> query.addFilterQuery(new String[]{xva$0}));
        }
        query.setFacet(customSolrParams.isFacet());
        if (customSolrParams.getFacetFields() != null) {
            customSolrParams.getFacetFields().stream().forEach(xva$0 -> query.addFacetField(new String[]{xva$0}));
        }
        query.setFacetMinCount(customSolrParams.getMincount());
        query.setFacetLimit(customSolrParams.getFacetLimit());
        query.setStart(Integer.valueOf(customSolrParams.getStart()));
        query.setRows(Integer.valueOf(customSolrParams.getRows()));
        customSolrParams.getSort().stream().forEach(sortClause -> query.addSort(sortClause));
        query.setShowDebugInfo(false);
        query.setFields(new String[]{"__json"});
        try {
            QueryResponse response = this.solrConnectionManager.solrClient.query((SolrParams)query);
            long totalMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            long qTime = response.getQTime();
            long overheadMs = totalMs - qTime;
            this.log.info("[Search] Solr timing for query: {}, total={}ms, qTime={}ms, overhead={}ms", (Object)query, (Object)totalMs, (Object)qTime, (Object)overheadMs);
            if (qTime > 10000L || overheadMs > 10000L) {
                this.log.warn("[Search] Slow Solr query detected for query: {}, total={}ms, qTime={}ms, overhead={}ms", (Object)query, (Object)totalMs, (Object)qTime, (Object)overheadMs);
            }
            return response;
        }
        catch (IOException | SolrServerException e) {
            this.log.error("Fait to get response for query {}.", (Object)solrQuery, (Object)e);
            return null;
        }
    }

    public QueryResponse cursorQuery(CustomSolrParams customSolrParams) {
        long start = System.nanoTime();
        SolrQuery solrQuery = SolrRepository.generateCursorSolrQuery((CustomSolrParams)customSolrParams);
        try {
            QueryResponse response = this.solrConnectionManager.solrClient.query((SolrParams)solrQuery);
            long totalMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            long qTime = response.getQTime();
            long overheadMs = totalMs - qTime;
            this.log.info("[Cursor] Response for query: {}, total={}ms, qTime={}ms, overhead={}ms", (Object)solrQuery, (Object)totalMs, (Object)qTime, (Object)overheadMs);
            if (qTime > 10000L || overheadMs > 10000L) {
                this.log.warn("[Cursor] Slow Solr query detected for query: {}, total={}ms, qTime={}ms, overhead={}ms", (Object)solrQuery, (Object)totalMs, (Object)qTime, (Object)overheadMs);
            }
            return response;
        }
        catch (IOException | SolrServerException e) {
            this.log.error("Fait to get response for query {}.", (Object)solrQuery, (Object)e);
            return null;
        }
    }

    private static SolrQuery generateCursorSolrQuery(CustomSolrParams customSolrParams) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(customSolrParams.getBasicSolrQuery().getQuery());
        customSolrParams.getBasicSolrQuery().getFq().stream().forEach(xva$0 -> solrQuery.addFilterQuery(new String[]{xva$0}));
        solrQuery.setFacet(false);
        solrQuery.set("cursorMark", new String[]{customSolrParams.getCursorMark()});
        solrQuery.setRows(Integer.valueOf(customSolrParams.getRows()));
        for (SolrQuery.SortClause sortClause : customSolrParams.getSort()) {
            solrQuery.addSort(sortClause);
        }
        if (customSolrParams != null && customSolrParams.getFacetFields() != null) {
            customSolrParams.getFacetFields().stream().forEach(xva$0 -> solrQuery.addFacetField(new String[]{xva$0}));
        }
        solrQuery.setShowDebugInfo(false);
        solrQuery.setFields(new String[]{"__json"});
        return solrQuery;
    }

    public QueryResponse queryOr(CustomSolrParams customSolrParams) {
        SolrQuery solrQuery;
        SolrQuery query = solrQuery = new SolrQuery();
        String clientQuery = customSolrParams.getBasicSolrQuery().getQuery();
        List clientFq = customSolrParams.getBasicSolrQuery().getFq();
        if (clientQuery != null || clientFq != null && !clientFq.isEmpty()) {
            if (clientQuery != null && clientFq != null && !clientFq.isEmpty()) {
                query.setQuery(customSolrParams.getBasicSolrQuery().getQuery() + " OR " + String.join((CharSequence)" OR ", customSolrParams.getBasicSolrQuery().getFq()));
            } else if (clientQuery != null) {
                query.setQuery(customSolrParams.getBasicSolrQuery().getQuery());
            } else if (clientFq != null && !clientFq.isEmpty()) {
                query.setQuery(String.join((CharSequence)" OR ", customSolrParams.getBasicSolrQuery().getFq()));
            }
        }
        query.setFacet(customSolrParams.isFacet());
        if (customSolrParams.getFacetFields() != null) {
            customSolrParams.getFacetFields().stream().forEach(xva$0 -> query.addFacetField(new String[]{xva$0}));
        }
        query.setFacetMinCount(customSolrParams.getMincount());
        query.setFacetLimit(customSolrParams.getFacetLimit());
        query.setStart(Integer.valueOf(customSolrParams.getStart()));
        query.setRows(Integer.valueOf(customSolrParams.getRows()));
        customSolrParams.getSort().stream().forEach(sortClause -> query.addSort(sortClause));
        query.setShowDebugInfo(true);
        try {
            QueryResponse response = this.solrConnectionManager.solrClient.query((SolrParams)query);
            return response;
        }
        catch (IOException | SolrServerException e) {
            this.log.error("Fail to get response for query {}", (Object)solrQuery, (Object)e);
            return null;
        }
    }
}

