/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.profile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import eu.dnetlib.common.profile.IResourceDaoSupport;
import eu.dnetlib.common.profile.Resource;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ResourceCache
implements IResourceDaoSupport {
    private final LoadingCache<String, Resource> cache = CacheBuilder.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Resource>(){

        public Resource load(String aKey) throws Exception {
            Object resource = null;
            if (aKey.startsWith("collection")) {
                return new Resource(this.byQuery(aKey));
            }
            return new Resource(this.byId(aKey));
        }

        private String byQuery(String aQuery) throws ISLookUpDocumentNotFoundException, ISLookUpException {
            return ((ISLookUpService)ResourceCache.this.lookupLocator.getService()).getResourceProfileByQuery(aQuery);
        }

        private String byId(String aId) throws ISLookUpDocumentNotFoundException, ISLookUpException {
            return ((ISLookUpService)ResourceCache.this.lookupLocator.getService()).getResourceProfile(aId);
        }
    });
    @javax.annotation.Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;

    @Override
    public List<Resource> getResources(String xquery) {
        return null;
    }

    @Override
    public Resource getResourceByXquery(String xquery) throws Exception {
        return (Resource)this.cache.get((Object)xquery);
    }

    @Override
    public Resource getResource(String id) throws Exception {
        return (Resource)this.cache.get((Object)id);
    }

    @Override
    public void updateResource(String id, Resource resource) {
    }

    @Override
    public void removeResource(String id, Resource resource) {
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }
}

