/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.services;

import eu.dnetlib.uoaadmintoolslibrary.dao.PluginDAO;
import eu.dnetlib.uoaadmintoolslibrary.dao.PluginTemplateDAO;
import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.plugin.Plugin;
import eu.dnetlib.uoaadmintoolslibrary.entities.plugin.PluginTemplate;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginService {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private PluginTemplateDAO pluginTemplateDAO;
    @Autowired
    private PluginDAO pluginDAO;

    public List<PluginTemplate> getPluginTemplates() {
        return this.getPluginTemplates(null);
    }

    public List<PluginTemplate> getPluginTemplates(String page) {
        List<PluginTemplate> templates = page != null ? this.pluginTemplateDAO.findByPage(page) : this.pluginTemplateDAO.findAll();
        templates.sort(Comparator.comparingInt(PluginTemplate::getOrder));
        return templates;
    }

    public List<Plugin> getPlugins() {
        return this.pluginDAO.findAll();
    }

    public Plugin getPluginById(String id) {
        return (Plugin)this.pluginDAO.findById(id).orElseThrow(() -> new NotFoundException("Plugin with id: " + id + " not found"));
    }

    public PluginTemplate getPluginTemplateById(String id) {
        return (PluginTemplate)this.pluginTemplateDAO.findById(id).orElseThrow(() -> new NotFoundException("Plugin Template with id: " + id + " not found"));
    }

    public List<Plugin> getPluginsByTemplateId(String id) {
        return this.pluginDAO.findByTemplateId(id);
    }

    public List<PluginTemplate> getPluginTemplatesByPage(Page page) {
        List<PluginTemplate> templates = this.pluginTemplateDAO.findByPage(page.getId());
        templates.sort(Comparator.comparingInt(PluginTemplate::getOrder));
        return templates;
    }

    public List<Plugin> getPluginsByPage(Portal portal, String pageId) {
        return this.pluginDAO.findByPageAndPid(pageId, portal.getPid());
    }

    public PluginTemplate savePluginTemplate(PluginTemplate pluginTemplate) {
        return (PluginTemplate)this.pluginTemplateDAO.save(pluginTemplate);
    }

    public Plugin savePlugin(Plugin plugin) {
        return (Plugin)this.pluginDAO.save(plugin);
    }

    public Plugin updatePluginStatus(String id, String status) {
        Plugin plugin = this.getPluginById(id);
        plugin.setActive(Boolean.parseBoolean(status));
        return (Plugin)this.pluginDAO.save(plugin);
    }

    public void deletePluginTemplate(String id) {
        this.pluginTemplateDAO.deleteById(id);
        List<Plugin> plugins = this.pluginDAO.findByTemplateId(id);
        for (Plugin p : plugins) {
            this.pluginDAO.deleteById(p.getId());
        }
    }

    public void deletePlugin(String id) {
        this.pluginDAO.deleteById(id);
    }
}

