/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.configuration;

import eu.dnetlib.uoaadmintoolslibrary.configuration.properties.AdminToolsProperties;
import eu.dnetlib.uoaadmintoolslibrary.configuration.properties.Mail;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
public class EmailConfig {
    private static final Logger logger = LogManager.getLogger(EmailConfig.class);
    private final Mail mail;

    @Autowired
    public EmailConfig(AdminToolsProperties properties) {
        this.mail = properties.getMail();
    }

    @Bean
    public JavaMailSender javaMailSender() {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(this.mail.getHost());
        mailSender.setPort(Integer.parseInt(this.mail.getPort()));
        mailSender.setUsername(this.mail.getUsername());
        mailSender.setPassword(this.mail.getPassword());
        mailSender.setProtocol(this.mail.getProtocol());
        mailSender.setDefaultEncoding(this.mail.getDefaultEncoding());
        Properties properties = mailSender.getJavaMailProperties();
        properties.put("mail.smtp.auth", this.mail.getAuth());
        properties.put("mail.smtp.starttls.enable", "true");
        if (this.mail.getSslProtocols() != null) {
            properties.put("mail.smtp.ssl.protocols", this.mail.getSslProtocols());
        }
        return mailSender;
    }
}

