/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivIdResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.DivIdService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DivIdController {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private DivIdService divIdService;
    @Autowired
    private PortalService portalService;

    @RequestMapping(value={"/div/full"}, method={RequestMethod.GET})
    public ResponseEntity<List<DivIdResponse>> getDivIdsFull(@RequestParam(value="page", required=false) String page, @RequestParam(value="name", required=false) String name, @RequestParam(value="portal", required=false) String pid) {
        return ResponseEntity.ok(this.divIdService.getDivIdsFull(this.portalService.getPortal(pid), page, name));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/div/save"}, method={RequestMethod.POST})
    public ResponseEntity<DivIdResponse> insertDivId(@RequestBody DivIdResponse divIdResponse) {
        return ResponseEntity.ok((Object)this.divIdService.insertDivId(divIdResponse));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/div/update"}, method={RequestMethod.POST})
    public ResponseEntity<DivIdResponse> updateDivId(@RequestBody DivIdResponse divIdResponse) {
        return ResponseEntity.ok((Object)this.divIdService.updateDivId(divIdResponse));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/div/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deleteDivIds(@RequestBody List<String> divIds) {
        return ResponseEntity.ok((Object)this.divIdService.deleteDivIds(divIds));
    }
}

