/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.services;

import eu.dnetlib.uoaadmintoolslibrary.dao.EntityDAO;
import eu.dnetlib.uoaadmintoolslibrary.entities.Entity;
import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalEntity;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityService {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private EntityDAO entityDAO;
    @Autowired
    private PageService pageService;
    @Autowired
    private PortalService portalService;

    public List<Entity> getAllEntities() {
        return this.entityDAO.findAll();
    }

    public void deleteAllEntities() {
        this.entityDAO.deleteAll();
    }

    public Entity insertOrUpdateEntity(Entity entity) {
        return (Entity)this.entityDAO.save(entity);
    }

    public Entity getEntity(String id) {
        return (Entity)this.entityDAO.findById(id).orElseThrow(() -> new NotFoundException("No entity with id " + id));
    }

    public Entity getEntityByPid(String pid) {
        return this.entityDAO.findByPid(pid);
    }

    public void deleteEntity(String id) {
        this.entityDAO.deleteById(id);
    }

    public PortalEntity updateEntity(PortalEntity portalEntity) {
        Entity entity = this.getEntityByPortalEntity(portalEntity);
        this.entityDAO.save(entity);
        return portalEntity;
    }

    public PortalEntity insertEntity(Entity entity) {
        Entity savedEntity = (Entity)this.entityDAO.save(entity);
        PortalEntity portalEntity = new PortalEntity(savedEntity);
        List<Portal> portals = this.portalService.getAllPortals();
        for (Portal portal : portals) {
            Map<String, Boolean> entities = portal.getEntities();
            entities.put(entity.getId(), true);
            portal.setEntities(entities);
            this.portalService.insertOrUpdatePortal(portal);
        }
        return portalEntity;
    }

    private Entity getEntityByPortalEntity(PortalEntity portalEntity) {
        Entity entity = new Entity();
        entity.setId(portalEntity.getId());
        entity.setPid(portalEntity.getPid());
        entity.setName(portalEntity.getName());
        return entity;
    }

    public Boolean deleteEntities(List<String> entities) {
        for (String id : entities) {
            List<Portal> portals = this.portalService.getAllPortals();
            for (Portal portal : portals) {
                Map<String, Boolean> portalEntities = portal.getEntities();
                portalEntities.remove(id);
                portal.setEntities(portalEntities);
                this.portalService.insertOrUpdatePortal(portal);
            }
            List<Page> pages = this.pageService.getAllPages(null, null, null);
            for (Page page : pages) {
                List<String> pageEntities = page.getEntities();
                Iterator<String> pageEntityIterator = pageEntities.iterator();
                while (pageEntityIterator.hasNext()) {
                    String pageEntity = pageEntityIterator.next();
                    if (!pageEntity.equals(id)) continue;
                    pageEntityIterator.remove();
                    break;
                }
                page.setEntities(pageEntities);
                this.pageService.insertOrUpdatePage(page);
            }
            this.entityDAO.deleteById(id);
        }
        return true;
    }
}

