/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.DivHelpContent;
import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.PageHelpContent;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivIdResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PageHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalEntity;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalPage;
import eu.dnetlib.uoaadmintoolslibrary.entities.plugin.Plugin;
import eu.dnetlib.uoaadmintoolslibrary.entities.plugin.PluginTemplate;
import eu.dnetlib.uoaadmintoolslibrary.services.DivHelpContentService;
import eu.dnetlib.uoaadmintoolslibrary.services.DivIdService;
import eu.dnetlib.uoaadmintoolslibrary.services.PageHelpContentService;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import eu.dnetlib.uoaadmintoolslibrary.services.PluginService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import eu.dnetlib.uoaadmintoolslibrary.utils.ResponseHelper;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"{portalType}"})
public class AdminPortalRelationsController {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private PortalService portalService;
    @Autowired
    private DivHelpContentService divHelpContentService;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private DivIdService divIdService;
    @Autowired
    private PageService pageService;
    @Autowired
    private PageHelpContentService pageHelpContentService;

    @RequestMapping(value={"/{pid}/entities"}, method={RequestMethod.GET})
    public ResponseEntity<List<PortalEntity>> getEntitiesForCommunity(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        return ResponseEntity.ok(this.portalService.getEntitiesForPortal(this.portalService.getPortal(portalType, pid, true)));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/entity/toggle"}, method={RequestMethod.POST})
    public ResponseEntity<Portal> toggleEntity(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody List<String> entityIds, @RequestParam(value="status") String status) {
        return ResponseEntity.ok((Object)this.portalService.toggleEntity(this.portalService.getPortal(portalType, pid, true), entityIds, status));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/{pid}/divhelpcontent"}, method={RequestMethod.GET})
    public ResponseEntity<List<DivHelpContentResponse>> getDivHelpContents(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        return ResponseEntity.ok(this.divHelpContentService.getDivHelpContents(this.portalService.getPortal(portalType, pid, true)));
    }

    @RequestMapping(value={"/{pid}/divhelpcontent/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<DivHelpContent> getDivHelpContent(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)this.divHelpContentService.getDivHelpContent(id, this.portalService.getPortal(portalType, pid, true)));
    }

    @RequestMapping(value={"/{pid}/{pageId}/divhelpcontent"}, method={RequestMethod.GET})
    public ResponseEntity<List<DivHelpContentResponse>> getDivHelpContentsByPageId(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @PathVariable(value="pageId") String pageId) {
        return ResponseEntity.ok(this.divHelpContentService.getDivHelpContents(this.portalService.getPortal(portalType, pid, true), this.pageService.getPage(pageId).getRoute(), null, null));
    }

    @RequestMapping(value={"/{pid}/divhelpcontent/page/count"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, Integer>> countDivHelpContentsForPages(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        HashMap<String, Integer> mapCount = new HashMap<String, Integer>();
        Portal portal = this.portalService.getPortal(portalType, pid, true);
        List<Page> pages = this.pageService.getAllPages(portal, null, null);
        for (Page page : pages) {
            mapCount.put(page.getId(), this.divHelpContentService.getDivHelpContentsBasic(portal, page.getId()).size());
        }
        return ResponseEntity.ok(mapCount);
    }

    @RequestMapping(value={"/{pid}/pluginTemplate/page/count"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, Integer>> countPluginTemplatesForPages(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        HashMap<String, Integer> mapCount = new HashMap<String, Integer>();
        for (Page page : this.pageService.getAllPages(this.portalService.getPortal(portalType, pid, true), null, null)) {
            mapCount.put(page.getId(), this.pluginService.getPluginTemplatesByPage(page).size());
        }
        return ResponseEntity.ok(mapCount);
    }

    @RequestMapping(value={"/{pid}/plugins/page/{pageId}"}, method={RequestMethod.GET})
    public ResponseEntity<List<Plugin>> getPluginsForPage(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @PathVariable(value="pageId") String pageId) {
        return ResponseEntity.ok(this.pluginService.getPluginsByPage(this.portalService.getPortal(portalType, pid, true), pageId));
    }

    @RequestMapping(value={"/{pid}/pluginTemplates/page/{pageId}"}, method={RequestMethod.GET})
    public ResponseEntity<List<PluginTemplate>> getPluginTemplatesForPages(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @PathVariable(value="pageId") String pageId) {
        return ResponseEntity.ok(this.pluginService.getPluginTemplatesByPage(this.pageService.getPage(this.portalService.getPortal(portalType, pid, true), pageId)));
    }

    @RequestMapping(value={"/{pid}/plugins/page/route"}, method={RequestMethod.GET})
    public ResponseEntity<List<Plugin>> getPluginsForPageRoute(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestParam(value="route") String route, HttpServletResponse HSResponse, HttpServletRequest request) {
        Portal portal = this.portalService.getPortal(portalType, pid, true);
        Page p = this.pageService.getPageByPortalAndRoute(portal, route);
        List<Object> response = new ArrayList();
        if (p != null) {
            response = this.pluginService.getPluginsByPage(portal, p.getId());
        }
        ResponseHelper.getCacheHeadersWithTag(((Object)response).toString(), HSResponse, request);
        return ResponseEntity.ok(response);
    }

    @RequestMapping(value={"/{pid}/pluginTemplates/page/route"}, method={RequestMethod.GET})
    public ResponseEntity<List<PluginTemplate>> getPluginTemplatesForPageRoute(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestParam(value="route") String route, HttpServletResponse HSResponse, HttpServletRequest request) {
        Portal portal = this.portalService.getPortal(portalType, pid, true);
        Page p = this.pageService.getPageByPortalAndRoute(portal, route);
        List<Object> response = new ArrayList();
        if (p != null) {
            response = this.pluginService.getPluginTemplatesByPage(p);
        }
        ResponseHelper.getCacheHeadersWithTag(((Object)response).toString(), HSResponse, request);
        return ResponseEntity.ok(response);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/divhelpcontent/save"}, method={RequestMethod.POST})
    public ResponseEntity<DivHelpContent> saveDivHelpContent(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody DivHelpContent divHelpContent) {
        Portal portal = this.portalService.getPortal(portalType, pid, true);
        divHelpContent.setPortal(portal.getId());
        return ResponseEntity.ok((Object)this.divHelpContentService.insertOrUpdateDivHelpContent(divHelpContent));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/divhelpcontent/update"}, method={RequestMethod.POST})
    public ResponseEntity<DivHelpContent> updateDivHelpContent(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody DivHelpContent divHelpContent) {
        Portal portal = this.portalService.getPortal(portalType, pid, true);
        divHelpContent.setPortal(portal.getId());
        return ResponseEntity.ok((Object)this.divHelpContentService.insertOrUpdateDivHelpContent(divHelpContent));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/divhelpcontent/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deleteDivHelpContents(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody List<String> divHelpContents) {
        return ResponseEntity.ok((Object)this.divHelpContentService.deleteDivHelpContents(this.portalService.getPortal(portalType, pid, true), divHelpContents));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/divhelpcontent/toggle"}, method={RequestMethod.POST})
    public ResponseEntity<List<String>> toggleDivHelpContent(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody List<String> divHelpContents, @RequestParam(value="status") String status) {
        return ResponseEntity.ok(this.divHelpContentService.toggleDivHelpContent(this.portalService.getPortal(portalType, pid, true), divHelpContents, status));
    }

    @RequestMapping(value={"/{pid}/div/full"}, method={RequestMethod.GET})
    public ResponseEntity<List<DivIdResponse>> getDivIdsFull(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestParam(value="page", required=false) String page) {
        return ResponseEntity.ok(this.divIdService.getDivIdsFull(this.portalService.getPortal(portalType, pid, true), page, null));
    }

    @RequestMapping(value={"/{pid}/div/{id}/full"}, method={RequestMethod.GET})
    public ResponseEntity<DivIdResponse> getDivIdFull(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @PathVariable(value="id") String id) {
        DivIdResponse divIdResponse = this.divIdService.getDivIdFull(id);
        if (!divIdResponse.getPortalType().equals(portalType.name())) {
            throw new MismatchingContentException("[" + String.valueOf((Object)portalType) + " - " + pid + "] Conflicting portal info: type: " + divIdResponse.getPortalType());
        }
        return ResponseEntity.ok((Object)divIdResponse);
    }

    @RequestMapping(value={"/{pid}/div/pages"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> getDivIdsPages(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        return ResponseEntity.ok(this.divIdService.getDivIdsPages(this.portalService.getPortal(portalType, pid, true)));
    }

    @RequestMapping(value={"/{pid}/pages"}, method={RequestMethod.GET})
    public ResponseEntity<List<PortalPage>> getPagesForPortalByType(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestParam(value="page_type", required=false) String page_type, @RequestParam(value="page_route", required=false) String page_route, @RequestParam(value="div", required=false) String div, @RequestParam(value="with_positions", required=false) String with_positions) {
        return ResponseEntity.ok(this.portalService.getPagesForPortalByType(this.portalService.getPortal(portalType, pid, true), page_type, page_route, div, with_positions));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/page/toggle"}, method={RequestMethod.POST})
    public ResponseEntity<Portal> togglePage(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody List<String> pageIds, @RequestParam(value="status") String status) {
        return ResponseEntity.ok((Object)this.portalService.togglePage(this.portalService.getPortal(portalType, pid, true), pageIds, status));
    }

    @RequestMapping(value={"/{pid}/page"}, method={RequestMethod.GET})
    public ResponseEntity<Page> getPageByRoute(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestParam(value="page_route") String page_route) {
        List<Page> pageInArray = this.pageService.getAllPages(this.portalService.getPortal(portalType, pid, true), page_route, null);
        if (pageInArray == null || pageInArray.isEmpty()) {
            throw new NotFoundException("No page with route: " + page_route + " found for portal with pid: " + pid);
        }
        return ResponseEntity.ok((Object)pageInArray.get(0));
    }

    @RequestMapping(value={"/{pid}/page/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Page> getPage(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @PathVariable(value="id") String id) {
        Page page = this.pageService.getPage(id);
        if (!page.getPortalType().equals(portalType.name())) {
            throw new MismatchingContentException("[" + String.valueOf((Object)portalType) + " - " + pid + "] Conflicting portal info: type: " + page.getPortalType());
        }
        return ResponseEntity.ok((Object)page);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/{pid}/pagehelpcontent"}, method={RequestMethod.GET})
    public ResponseEntity<List<PageHelpContentResponse>> getPageHelpContents(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        return ResponseEntity.ok(this.pageHelpContentService.getPageHelpContents(this.portalService.getPortal(portalType, pid, true), null, null, null, null));
    }

    @RequestMapping(value={"/{pid}/{pageId}/pagehelpcontent"}, method={RequestMethod.GET})
    public ResponseEntity<List<PageHelpContent>> getPageHelpContentsByPageId(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @PathVariable(value="pageId") String pageId) {
        return ResponseEntity.ok(this.pageHelpContentService.getPageHelpContentsBasic(this.portalService.getPortal(portalType, pid, true), pageId));
    }

    @RequestMapping(value={"/{pid}/pagehelpcontent/page/count"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, Integer>> countPageHelpContentsForPages(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        HashMap<String, Integer> mapCount = new HashMap<String, Integer>();
        Portal portal = this.portalService.getPortal(portalType, pid, true);
        List<Page> pages = this.pageService.getAllPages(portal, null, null);
        for (Page page : pages) {
            mapCount.put(page.getId(), this.pageHelpContentService.getPageHelpContentsBasic(portal, page.getId()).size());
        }
        return ResponseEntity.ok(mapCount);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/pagehelpcontent/save"}, method={RequestMethod.POST})
    public ResponseEntity<PageHelpContent> insertPageHelpContent(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody PageHelpContent pageHelpContent) {
        Portal portal = this.portalService.getPortal(portalType, pid, true);
        pageHelpContent.setPortal(portal.getId());
        return ResponseEntity.ok((Object)this.pageHelpContentService.insertOrUpdatePageHelpContent(pageHelpContent));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/pagehelpcontent/update"}, method={RequestMethod.POST})
    public ResponseEntity<PageHelpContent> updatePageHelpContent(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody PageHelpContent pageHelpContent) {
        Portal portal = this.portalService.getPortal(portalType, pid, true);
        pageHelpContent.setPortal(portal.getId());
        return ResponseEntity.ok((Object)this.pageHelpContentService.insertOrUpdatePageHelpContent(pageHelpContent));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/pagehelpcontent/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deletePageHelpContents(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody List<String> pageHelpContents) {
        return ResponseEntity.ok((Object)this.pageHelpContentService.deletePageHelpContents(this.portalService.getPortal(portalType, pid, true), pageHelpContents));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#portalType), @AuthorizationService.manager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/pagehelpcontent/toggle"}, method={RequestMethod.POST})
    public ResponseEntity<List<String>> togglePageHelpContent(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody List<String> pageHelpContents, @RequestParam(value="status") String status) {
        return ResponseEntity.ok(this.pageHelpContentService.togglePageHelpContent(this.portalService.getPortal(portalType, pid, true), pageHelpContents, status));
    }
}

