/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PageHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"{portalType}"})
public class PortalController {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private PortalService portalService;

    @RequestMapping(value={"/{pid}"}, method={RequestMethod.GET})
    public ResponseEntity<Portal> getPortal(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        this.log.debug("PID: " + pid);
        return ResponseEntity.ok((Object)this.portalService.getPortal(portalType, pid, true));
    }

    @RequestMapping(value={"/{pid}/full"}, method={RequestMethod.GET})
    public ResponseEntity<PortalResponse> getPortalFull(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        return ResponseEntity.ok((Object)this.portalService.getPortalFull(this.portalService.getPortal(portalType, pid, true)));
    }

    @RequestMapping(value={"/{pid}/divhelpcontent/grouped"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, List<DivHelpContentResponse>>> getDivHelpContentsByPosition(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestParam String page, @RequestParam String active) {
        return ResponseEntity.ok(this.portalService.getDivHelpContentsByPosition(this.portalService.getPortal(portalType, pid, true), page, active));
    }

    @RequestMapping(value={"/{pid}/pagehelpcontent/grouped"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, List<PageHelpContentResponse>>> getPageHelpContentsByPosition(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestParam String page, @RequestParam String active) {
        return ResponseEntity.ok(this.portalService.getPageHelpContentsByPosition(this.portalService.getPortal(portalType, pid, true), page, active));
    }
}

