/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.services;

import eu.dnetlib.uoaadmintoolslibrary.dao.NewsDAO;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.news.News;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class NewsService {
    private final NewsDAO dao;

    @Autowired
    public NewsService(NewsDAO dao) {
        this.dao = dao;
    }

    public List<News> getAllNews(PortalType portalType, String pid) {
        return this.dao.findByTypeAndPid(portalType, pid, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"}));
    }

    public News saveNews(PortalType portalType, String pid, News news) {
        news.setType(portalType);
        news.setPid(pid);
        return (News)this.dao.save(news);
    }

    public void deleteNews(PortalType portalType, String pid, String id) {
        this.dao.delete(this.dao.findByTypeAndPidAndId(portalType, pid, id).orElseThrow(() -> new NotFoundException("Could not find news with id: " + id)));
    }
}

