/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.configuration.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import eu.dnetlib.uoaadmintools.configuration.properties.Mongodb;
import eu.dnetlib.uoaadmintools.configuration.properties.Properties;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"eu.dnetlib.uoaadmintools.dao", "eu.dnetlib.uoaadmintoolslibrary.dao"})
public class MongoConnection {
    private final Mongodb config;

    @Autowired
    public MongoConnection(Properties properties) {
        this.config = properties.getMongodb();
    }

    @Bean(name={"mongoTemplate"})
    public MongoTemplate getMongoTemplate() {
        return new MongoTemplate(this.getMongoClient(), this.config.getDatabase());
    }

    private MongoClient getMongoClient() {
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyToClusterSettings(b -> b.hosts(Collections.singletonList(new ServerAddress(this.config.getHost(), this.config.getPort()))));
        if (this.config.getUsername() != null && this.config.getPassword() != null) {
            MongoCredential credential = MongoCredential.createCredential((String)this.config.getUsername(), (String)this.config.getDatabase(), (char[])this.config.getPassword().toCharArray());
            builder.credential(credential);
        }
        return MongoClients.create((MongoClientSettings)builder.build());
    }
}

