/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/explore"})
@PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
public class ExploreController {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private PortalService portalService;
    @Autowired
    private PageService pageService;

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseEntity<PortalResponse> updateExplore(@RequestBody Portal portal) {
        if (!portal.getType().equals("explore")) {
            throw new MismatchingContentException("Update Explore: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of explore");
        }
        String old_pid = this.portalService.getPortalById(portal.getId()).getPid();
        String new_pid = portal.getPid();
        PortalResponse portalResponse = this.portalService.updatePortal(portal);
        if (!old_pid.equals(new_pid)) {
            this.pageService.updatePid(old_pid, portal);
        }
        return ResponseEntity.ok((Object)portalResponse);
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<PortalResponse> insertExplore(@RequestBody Portal portal) {
        if (!portal.getType().equals("explore")) {
            throw new MismatchingContentException("Save Explore: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of explore");
        }
        return ResponseEntity.ok((Object)this.portalService.insertPortal(portal));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deleteExplore(@RequestBody List<String> portals) {
        for (String id : portals) {
            Portal portal = this.portalService.getPortalById(id);
            if (!portal.getType().equals("explore")) {
                throw new MismatchingContentException("Delete Explore: Portal with id: " + id + " has type: " + portal.getType() + " instead of explore");
            }
            this.portalService.deletePortal(id);
        }
        return ResponseEntity.ok((Object)true);
    }
}

