/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.entities.Manager;
import eu.dnetlib.uoaadmintools.entities.Notifications;
import eu.dnetlib.uoaadmintools.services.ManagerService;
import eu.dnetlib.uoaadmintools.services.NotificationsService;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.Email;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.EmailRecaptcha;
import eu.dnetlib.uoaadmintoolslibrary.exceptions.InvalidReCaptchaException;
import eu.dnetlib.uoaadmintoolslibrary.services.EmailService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaadmintoolslibrary.utils.RolesUtils;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EmailController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final EmailService service;
    private final RolesUtils rolesUtils;
    private final PortalService portalService;
    private final ManagerService managerService;
    private final NotificationsService notificationsService;
    private final EmailService emailService;

    @Autowired
    public EmailController(EmailService service, RolesUtils rolesUtils, PortalService portalService, ManagerService managerService, NotificationsService notificationsService, EmailService emailService) {
        this.service = service;
        this.rolesUtils = rolesUtils;
        this.portalService = portalService;
        this.managerService = managerService;
        this.notificationsService = notificationsService;
        this.emailService = emailService;
    }

    @RequestMapping(value={"/contact"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> contact(@RequestBody EmailRecaptcha form) throws InvalidReCaptchaException {
        this.service.processResponse(form.getRecaptcha());
        Email email = form.getEmail();
        return ResponseEntity.ok((Object)this.service.send(email.getRecipients(), email.getSubject(), email.getBody(), Boolean.valueOf(false)));
    }

    @RequestMapping(value={"/sendMail"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, ArrayList<String>>> sendEmail(@RequestBody Email email, @RequestParam(required=false, name="optional") Optional<Boolean> optional) {
        String successString = "success";
        String failureString = "failure";
        HashMap mailResults = new HashMap();
        boolean bcc = optional.orElse(true);
        for (String userMail : email.getRecipients()) {
            boolean success = this.service.send(Collections.singletonList(userMail), email.getSubject(), email.getBody(), Boolean.valueOf(bcc));
            if (success) {
                if (!mailResults.containsKey(successString)) {
                    mailResults.put(successString, new ArrayList());
                }
                ((ArrayList)mailResults.get(successString)).add(userMail);
                continue;
            }
            if (!mailResults.containsKey(failureString)) {
                mailResults.put(failureString, new ArrayList());
            }
            ((ArrayList)mailResults.get(failureString)).add(userMail);
        }
        return ResponseEntity.ok(mailResults);
    }

    @RequestMapping(value={"/notifyNewManager"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> notifyNewManager(@RequestBody Email email) throws Exception {
        return ResponseEntity.ok((Object)this.service.send(Collections.singletonList(this.rolesUtils.getEmail()), email.getSubject(), email.getBody(), Boolean.valueOf(true)));
    }

    @RequestMapping(value={"/notifyManagers/{pid}/{newRoleType}"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> notifyManagers(@PathVariable(value="pid") String pid, @PathVariable(value="newRoleType") String newRoleType, @RequestBody Email email) throws Exception {
        Portal portal = this.portalService.getPortal(pid);
        if (portal == null) {
            throw new NotFoundException("Portal not found");
        }
        List emails = Arrays.stream(this.managerService.getManagers(pid)).map(Manager::getEmail).collect(Collectors.toList());
        List notifyRecipients = emails.stream().filter(address -> !address.equals(this.rolesUtils.getEmail())).filter(address -> {
            Notifications notifications = this.notificationsService.getUserNotifications(portal);
            return notifications == null || newRoleType.equals("manager") && notifications.getNotifyForNewManagers() != false || newRoleType.equals("subscriber") && notifications.getNotifyForNewSubscribers() != false;
        }).collect(Collectors.toList());
        if (!notifyRecipients.isEmpty()) {
            email.setBody(email.getBody().replace("((__managers__))", String.join((CharSequence)", ", emails)));
            return ResponseEntity.ok((Object)this.emailService.send(notifyRecipients, email.getSubject(), email.getBody(), Boolean.valueOf(false)));
        }
        this.log.debug("There are no users to notify ");
        return ResponseEntity.ok((Object)true);
    }
}

