/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.configuration.GlobalVars;
import eu.dnetlib.uoaadmintools.configuration.mongo.MongoConnection;
import eu.dnetlib.uoaadmintools.configuration.properties.Managers;
import eu.dnetlib.uoaadmintools.configuration.properties.Mongodb;
import eu.dnetlib.uoaadmintools.configuration.properties.Properties;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdminToolsDeployService {
    private final MongoConnection mongoConnection;
    private final Mongodb mongodb;
    private final Managers managers;
    private final String cache;
    private final GlobalVars globalVars;

    @Autowired
    public AdminToolsDeployService(MongoConnection mongoConnection, Properties properties, GlobalVars globalVars) {
        this.mongoConnection = mongoConnection;
        this.mongodb = properties.getMongodb();
        this.managers = properties.getManagers();
        this.cache = properties.getCache();
        this.globalVars = globalVars;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.mongodb.getHost() == null || this.mongodb.getHost().isEmpty()) {
            throw new RuntimeException("admin-tools.mongodb.host is missing!");
        }
        if (this.mongodb.getDatabase() == null || this.mongodb.getDatabase().isEmpty()) {
            throw new RuntimeException("admin-tools.mongodb.database is missing!");
        }
        if (this.managers.getId() == null || this.managers.getId().isEmpty()) {
            throw new RuntimeException("admin-tools.managers.id is missing!");
        }
        if (this.managers.getEmail() == null || this.managers.getEmail().isEmpty()) {
            throw new RuntimeException("admin-tools.managers.email is missing!");
        }
        if (this.cache == null || this.cache.isEmpty()) {
            throw new RuntimeException("admin-tools.cache is missing!");
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> response = new HashMap<String, String>();
        MongoTemplate mt = this.mongoConnection.getMongoTemplate();
        Document ping = new Document("ping", (Object)1);
        try {
            Document answer = mt.executeCommand(ping);
            response.put("Mongo try: error", String.valueOf(answer.getDouble((Object)"ok") == 1.0));
        }
        catch (Exception e) {
            response.put("Mongo catch: error", e.getMessage());
        }
        response.put("admin-tools.mongodb.database", this.mongodb.getDatabase());
        response.put("admin-tools.mongodb.host", this.mongodb.getHost());
        response.put("admin-tools.mongodb.port", "" + this.mongodb.getPort());
        response.put("admin-tools.mongodb.username", this.mongodb.getUsername() == null ? null : "[unexposed value]");
        response.put("admin-tools.mongodb.password", this.mongodb.getPassword() == null ? null : "[unexposed value]");
        response.put("admin-tools.managers.id", this.managers.getId());
        response.put("admin-tools.managers.email", this.managers.getEmail());
        response.put("admin-tools.cache", this.cache);
        response.put("Date of deploy", GlobalVars.date.toString());
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return response;
    }
}

