/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.dao.LayoutDAO;
import eu.dnetlib.uoaadmintools.entities.Layout;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutService {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final LayoutDAO layoutDAO;

    @Autowired
    public LayoutService(LayoutDAO layoutDAO) {
        this.layoutDAO = layoutDAO;
    }

    public List<Layout> findAll() {
        return this.layoutDAO.findAll();
    }

    public Layout findByPid(String pid) {
        return this.layoutDAO.findByPortalPid(pid).orElse(null);
    }

    public void updatePid(String oldPid, Portal portal) {
        Layout layout = this.findByPid(oldPid);
        if (layout != null) {
            layout.setPortalPid(portal.getPid());
            this.layoutDAO.save((Object)layout);
        }
    }

    public void deleteByPid(String pid) {
        Layout layout = this.findByPid(pid);
        if (layout != null) {
            this.layoutDAO.delete((Object)layout);
        }
    }

    public Layout save(Layout layout) {
        Layout old = this.findByPid(layout.getPortalPid());
        if (old != null) {
            layout.setId(old.getId());
        }
        return (Layout)this.layoutDAO.save((Object)layout);
    }
}

