/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.dao.MenuDAO;
import eu.dnetlib.uoaadmintools.dao.MenuItemDAO;
import eu.dnetlib.uoaadmintools.entities.menu.Menu;
import eu.dnetlib.uoaadmintools.entities.menu.MenuAlignment;
import eu.dnetlib.uoaadmintools.entities.menu.MenuFull;
import eu.dnetlib.uoaadmintools.entities.menu.MenuItem;
import eu.dnetlib.uoaadmintools.entities.menu.MenuItemFull;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuService {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final MenuDAO menuDAO;
    private final MenuItemDAO menuItemDAO;

    @Autowired
    public MenuService(MenuDAO menuDAO, MenuItemDAO menuItemDAO) {
        this.menuDAO = menuDAO;
        this.menuItemDAO = menuItemDAO;
    }

    public MenuItem getMenuItem(String id) {
        return (MenuItem)this.menuItemDAO.findById((Object)id).orElseThrow(() -> new NotFoundException("Menu item with id: " + id + " not found"));
    }

    public MenuItemFull getMenuItemFull(String id) {
        return this.getMenuItemFull(id, 1);
    }

    public MenuItemFull getMenuItemFull(String id, int maxDepth) {
        MenuItem menuItem = this.getMenuItem(id);
        MenuItemFull menuItemFull = new MenuItemFull(menuItem);
        if (maxDepth == 0) {
            menuItemFull.setItems(new ArrayList());
        } else {
            menuItemFull.setItems(menuItem.getItems().stream().map(item -> this.getMenuItemFull(item, maxDepth - 1)).collect(Collectors.toList()));
        }
        return menuItemFull;
    }

    public List<MenuItem> getMenuItemsByParent(String parentId, String portalPid) {
        if (portalPid != null) {
            return this.menuItemDAO.findByParentItemIdAndPortalPid(parentId, portalPid);
        }
        return this.menuItemDAO.findByParentItemId(parentId);
    }

    public List<MenuItemFull> getRootMenuItemsFull(String portalPid) {
        List rootMenuItems = this.getMenuItemsByParent(null, portalPid);
        ArrayList<MenuItemFull> rootMenuItemsFull = new ArrayList<MenuItemFull>();
        for (MenuItem rootMenuItem : rootMenuItems) {
            MenuItemFull rootMenuItemFull = new MenuItemFull(rootMenuItem);
            ArrayList<MenuItemFull> childrenMenuItemsFull = new ArrayList<MenuItemFull>();
            for (String childMenuItemString : rootMenuItem.getItems()) {
                childrenMenuItemsFull.add(this.getMenuItemFull(childMenuItemString));
            }
            rootMenuItemFull.setItems(childrenMenuItemsFull);
            rootMenuItemsFull.add(rootMenuItemFull);
        }
        return rootMenuItemsFull;
    }

    public MenuFull getMenuFull(String portalPid) {
        MenuFull menuFull = new MenuFull();
        Menu menu = this.menuDAO.findByPortalPid(portalPid).orElse(null);
        menuFull.setPortalPid(portalPid);
        if (menu == null) {
            menuFull.setFeaturedMenuEnabled(true);
            menuFull.setMenuEnabled(true);
            menuFull.setFeaturedAlignment(MenuAlignment.CENTER.name());
        } else {
            menuFull.setFeaturedMenuItems(menu.getFeaturedMenuItems().stream().map(item -> this.getFullRootMenuItemById(item, portalPid, Boolean.valueOf(true))).collect(Collectors.toList()));
            menuFull.setMenuItems(menu.getMenuItems().stream().map(item -> this.getFullRootMenuItemById(item, portalPid, Boolean.valueOf(false))).collect(Collectors.toList()));
            menuFull.setFeaturedMenuEnabled(menu.getIsFeaturedMenuEnabled());
            menuFull.setMenuEnabled(menu.getIsMenuEnabled());
            menuFull.setFeaturedAlignment(menu.getFeaturedAlignment());
        }
        return menuFull;
    }

    private MenuItemFull getFullRootMenuItemById(String id, String portalPid, Boolean isFeatured) {
        MenuItem rootMenuItem = this.getMenuItem(id);
        if (rootMenuItem.getIsFeatured() != isFeatured) {
            throw new MismatchingContentException("getFullRootMenuItemById: Menu item should " + (isFeatured != false ? "" : "not ") + "be featured");
        }
        if (!rootMenuItem.getPortalPid().equals(portalPid)) {
            throw new MismatchingContentException("getFullRootMenuItemById: Menu item with id: " + rootMenuItem.getId() + " has portal pid: " + rootMenuItem.getPortalPid() + " instead of " + portalPid);
        }
        if (rootMenuItem.getParentItemId() != null) {
            throw new MismatchingContentException("getFullRootMenuItemById: Menu item should be root (no parentId), but instead parentId: " + rootMenuItem.getParentItemId());
        }
        MenuItemFull rootMenuItemFull = new MenuItemFull(rootMenuItem);
        rootMenuItemFull.setItems(rootMenuItem.getItems().stream().map(arg_0 -> this.getMenuItemFull(arg_0)).collect(Collectors.toList()));
        return rootMenuItemFull;
    }

    private MenuItemFull insertMenuItem(MenuItem menuItem, String portalPid) {
        MenuItem parent = null;
        if (menuItem.getParentItemId() != null && !menuItem.getParentItemId().isEmpty()) {
            parent = this.getMenuItem(menuItem.getParentItemId());
            if (!parent.getPortalPid().equals(portalPid)) {
                throw new MismatchingContentException("insertMenuItem: parent (" + parent.getParentItemId() + ") of MenuItem has portalPid: " + parent.getPortalPid() + " instead of " + portalPid);
            }
        } else {
            menuItem.setParentItemId(null);
        }
        if (menuItem.getItems() == null) {
            menuItem.setItems(new ArrayList());
        }
        this.menuItemDAO.save((Object)menuItem);
        if (parent != null) {
            List siblingsOfNew = parent.getItems();
            siblingsOfNew.add(menuItem.getId());
            parent.setItems(siblingsOfNew);
            this.menuItemDAO.save((Object)parent);
        }
        MenuItemFull menuItemFull = new MenuItemFull(menuItem);
        menuItemFull.setItems(new ArrayList());
        return menuItemFull;
    }

    public MenuItemFull insertMenuItemInMenu(MenuItem menuItem, String portalPid) {
        MenuItemFull menuItemFull = this.insertMenuItem(menuItem, portalPid);
        Menu menu = this.menuDAO.findByPortalPid(portalPid).orElse(null);
        if (menu == null) {
            menu = new Menu(portalPid);
        }
        if (menuItem.getIsFeatured().booleanValue() && menuItem.getParentItemId() == null) {
            menu.getFeaturedMenuItems().add(menuItemFull.getId());
        } else if (menuItem.getParentItemId() == null) {
            menu.getMenuItems().add(menuItemFull.getId());
        }
        this.menuDAO.save((Object)menu);
        return menuItemFull;
    }

    public MenuItemFull updateMenuItem(MenuItemFull menuItemFull) {
        MenuItem menuItem = this.getMenuItemByMenuItemFull(menuItemFull);
        MenuItem oldMenuItem = this.getMenuItem(menuItemFull.getId());
        menuItem.setItems(oldMenuItem.getItems());
        menuItem.setParentItemId(oldMenuItem.getParentItemId());
        this.menuItemDAO.save((Object)menuItem);
        menuItemFull = this.getMenuItemFull(menuItem.getId());
        return menuItemFull;
    }

    public MenuItemFull updateMenu(MenuItemFull menuItemFull, String portalPid) {
        menuItemFull = this.updateMenuItem(menuItemFull);
        Menu menu = (Menu)this.menuDAO.findByPortalPid(portalPid).orElseThrow(() -> new NotFoundException("updateMenu: No Menu found for portal pid: " + portalPid));
        List featuredMenuItems = menu.getFeaturedMenuItems();
        List menuItems = menu.getMenuItems();
        if (menuItemFull.getIsFeatured().booleanValue() && menuItemFull.getParentItemId() == null && !featuredMenuItems.contains(menuItemFull.getId())) {
            featuredMenuItems.add(menuItemFull.getId());
        } else if ((!menuItemFull.getIsFeatured().booleanValue() || menuItemFull.getParentItemId() != null) && featuredMenuItems.contains(menuItemFull.getId())) {
            featuredMenuItems.remove(menuItemFull.getId());
        } else if (!menuItemFull.getIsFeatured().booleanValue() && menuItemFull.getParentItemId() == null && !menuItems.contains(menuItemFull.getId())) {
            menuItems.add(menuItemFull.getId());
        } else if (menuItemFull.getIsFeatured().booleanValue() || menuItemFull.getParentItemId() != null) {
            menuItems.remove(menuItemFull.getId());
        }
        this.menuDAO.save((Object)menu);
        return menuItemFull;
    }

    public Boolean deleteMenuItem(String id, String portalPid) throws Exception {
        Menu menu = (Menu)this.menuDAO.findByPortalPid(portalPid).orElseThrow(() -> new NotFoundException("deleteMenuItem: No Menu found for portal pid: " + portalPid));
        List featuredMenuItems = menu.getFeaturedMenuItems();
        List menuItems = menu.getMenuItems();
        if (featuredMenuItems.contains(id)) {
            featuredMenuItems.remove(id);
        } else {
            menuItems.remove(id);
        }
        this.menuDAO.save((Object)menu);
        this.log.debug("delete menu item; " + id);
        ArrayList<String> menuItemsToDelete = new ArrayList<String>();
        menuItemsToDelete.add(id);
        return this.deleteMenuItems(menuItemsToDelete, portalPid);
    }

    public Boolean deleteMenuItems(List<String> menuItems, String portalPid) throws Exception {
        if (menuItems == null) {
            return true;
        }
        for (String id : menuItems) {
            MenuItem menuItem = this.getMenuItem(id);
            if (!portalPid.equals(menuItem.getPortalPid())) {
                throw new MismatchingContentException("Delete Menu Items: MenuItem with id: " + id + " has portalPid: " + menuItem.getPortalPid() + " instead of " + portalPid);
            }
            this.deleteMenuItems(menuItem.getItems(), portalPid);
            if (menuItem.getParentItemId() != null && !menuItem.getParentItemId().isEmpty()) {
                MenuItem parent = this.getMenuItem(menuItem.getParentItemId());
                List siblingsOfDeleted = parent.getItems();
                siblingsOfDeleted.remove(id);
                parent.setItems(siblingsOfDeleted);
                this.menuItemDAO.save((Object)parent);
            }
            this.menuItemDAO.delete((Object)menuItem);
        }
        return true;
    }

    public Boolean deleteMenuByPortalPid(String portalPid) throws Exception {
        Menu menu = this.menuDAO.findByPortalPid(portalPid).orElse(null);
        if (menu != null) {
            this.deleteMenuItems(menu.getMenuItems(), portalPid);
            this.deleteMenuItems(menu.getFeaturedMenuItems(), portalPid);
            this.menuDAO.deleteByPortalPid(portalPid);
        }
        return true;
    }

    public Boolean reorderMenuItems(List<MenuItemFull> menuItemsFull, String portalPid) {
        ArrayList<String> menuItemIds = new ArrayList<String>();
        boolean isFeatured = menuItemsFull.get(0).getIsFeatured();
        String parentId = menuItemsFull.get(0).getParentItemId();
        for (MenuItemFull menuItem : menuItemsFull) {
            if (!portalPid.equals(menuItem.getPortalPid())) {
                throw new MismatchingContentException("reorderMenuItems: MenuItems for reordering have not the same portalPid");
            }
            if (menuItem.getIsFeatured() != isFeatured) {
                throw new MismatchingContentException("reorderMenuItems: MenuItems for reordering have not the same isFeatured");
            }
            if (menuItem.getParentItemId() == null && parentId != null || parentId == null && menuItem.getParentItemId() != null || parentId != null && !menuItem.getParentItemId().equals(parentId)) {
                throw new MismatchingContentException("reorderMenuItems: MenuItems for reordering have not the same parentItemId");
            }
            menuItemIds.add(menuItem.getId());
        }
        if (parentId != null) {
            MenuItem parent = this.getMenuItem(parentId);
            this.addSavedMenuItems(parent.getItems(), menuItemIds);
            parent.setItems(menuItemIds);
            this.menuItemDAO.save((Object)parent);
        } else if (isFeatured) {
            menu = (Menu)this.menuDAO.findByPortalPid(portalPid).orElseThrow(() -> new NotFoundException("reorderMenuItems: No Menu found for portalPid: " + portalPid));
            this.addSavedMenuItems(menu.getMenuItems(), menuItemIds);
            menu.setFeaturedMenuItems(menuItemIds);
            this.menuDAO.save((Object)menu);
        } else {
            menu = (Menu)this.menuDAO.findByPortalPid(portalPid).orElseThrow(() -> new NotFoundException("reorderMenuItems: No Menu found for portalPid: " + portalPid));
            this.addSavedMenuItems(menu.getMenuItems(), menuItemIds);
            menu.setMenuItems(menuItemIds);
            this.menuDAO.save((Object)menu);
        }
        return true;
    }

    private void addSavedMenuItems(List<String> savedMenuItems, List<String> menuItemIds) {
        for (String menuId : savedMenuItems) {
            if (menuItemIds.contains(menuId)) continue;
            menuItemIds.add(menuId);
        }
    }

    private MenuItem getMenuItemByMenuItemFull(MenuItemFull menuItemFull) {
        MenuItem menuItem = new MenuItem();
        menuItem.setId(menuItemFull.getId());
        menuItem.setTitle(menuItemFull.getTitle());
        menuItem.setUrl(menuItemFull.getUrl());
        menuItem.setType(menuItemFull.getType());
        menuItem.setTarget(menuItemFull.getTarget());
        menuItem.setRoute(menuItemFull.getRoute());
        menuItem.setPortalPid(menuItemFull.getPortalPid());
        menuItem.setParentItemId(menuItemFull.getParentItemId());
        menuItem.setIsFeatured(menuItemFull.getIsFeatured());
        List menuItemsFull = menuItemFull.getItems();
        ArrayList<String> menuItems = new ArrayList<String>();
        if (menuItemsFull != null) {
            for (MenuItemFull childMenuItemFull : menuItemsFull) {
                menuItems.add(childMenuItemFull.getId());
            }
        }
        menuItem.setItems(menuItems);
        return menuItem;
    }

    public Menu toggleMenu(String pid, String status, String isFeatured) {
        Menu menu = (Menu)this.menuDAO.findByPortalPid(pid).orElseThrow(() -> new NotFoundException("toggle Menu: No Menu found for portalPid: " + pid));
        if (Boolean.parseBoolean(isFeatured)) {
            menu.setFeaturedMenuEnabled(Boolean.parseBoolean(status));
        } else {
            menu.setMenuEnabled(Boolean.parseBoolean(status));
        }
        return (Menu)this.menuDAO.save((Object)menu);
    }

    public Menu alignMenu(String pid, String alignment) {
        Menu menu = (Menu)this.menuDAO.findByPortalPid(pid).orElseThrow(() -> new NotFoundException("align Menu: No Menu found for portalPid: " + pid));
        menu.setFeaturedAlignment(alignment);
        return (Menu)this.menuDAO.save((Object)menu);
    }

    public void updatePid(String oldPid, Portal portal) {
        this.log.debug("menu service: updatePid");
        Menu menu = this.menuDAO.findByPortalPid(oldPid).orElse(null);
        if (menu != null) {
            menu.setPortalPid(portal.getPid());
            this.menuDAO.save((Object)menu);
            this.log.debug("menu saved!");
        }
        List menuItems = this.menuItemDAO.findByPortalPid(oldPid);
        menuItems.forEach(menuItem -> {
            menuItem.setPortalPid(portal.getPid());
            this.menuItemDAO.save(menuItem);
            this.log.debug("menuItem saved!");
        });
    }
}

