/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.configuration.properties.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/cache"})
public class BrowserCacheController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final RestTemplate restTemplate;
    private final String cache;

    @Autowired
    public BrowserCacheController(RestTemplate restTemplate, Properties properties) {
        this.restTemplate = restTemplate;
        this.cache = properties.getCache();
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'), @AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/{pid}"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> purge(@PathVariable(value="pid") String pid) {
        this.restTemplate.getForEntity(this.cache.replace("{community}", pid), String.class, new Object[0]);
        return ResponseEntity.ok((Object)true);
    }
}

