/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.configuration.properties.Managers;
import eu.dnetlib.uoaadmintools.configuration.properties.Properties;
import eu.dnetlib.uoaadmintools.entities.Manager;
import eu.dnetlib.uoaadmintools.entities.ManagerType;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ManagerService {
    private final Managers config;
    private final RestTemplate restTemplate;

    @Autowired
    public ManagerService(Properties properties, RestTemplate restTemplate) {
        this.config = properties.getManagers();
        this.restTemplate = restTemplate;
    }

    public Manager[] getManagers(String pid) {
        return this.getManagers(pid, ManagerType.EMAIL);
    }

    public Manager[] getManagers(String pid, ManagerType type) {
        String url = type == ManagerType.EMAIL ? this.config.getEmail() : this.config.getId();
        ResponseEntity responseEntity = this.restTemplate.getForEntity(url.replace("{community}", pid), Manager[].class, new Object[0]);
        Manager[] managers = (Manager[])responseEntity.getBody();
        if (managers != null && responseEntity.getStatusCode() == HttpStatus.OK) {
            return managers;
        }
        throw new NotFoundException("No managers has been found for community " + pid);
    }
}

