/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.dao.NotificationsDAO;
import eu.dnetlib.uoaadmintools.entities.Notifications;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.utils.RolesUtils;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationsService {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final NotificationsDAO notificationsDAO;
    private final RolesUtils rolesUtils;

    @Autowired
    public NotificationsService(NotificationsDAO notificationsDAO, RolesUtils rolesUtils) {
        this.notificationsDAO = notificationsDAO;
        this.rolesUtils = rolesUtils;
    }

    public Notifications getUserNotifications(Portal portal) {
        return this.notificationsDAO.findByManagerEmailAndPortalPid(this.rolesUtils.getEmail(), portal.getPid()).orElse(null);
    }

    public List<Notifications> getAllNotifications(Portal portal) {
        return this.notificationsDAO.findByPortalPid(portal.getPid());
    }

    public void deleteUserNotifications(Portal portal) {
        Notifications notifications = this.getUserNotifications(portal);
        if (notifications == null) {
            throw new NotFoundException("Notifications settings for community with pid: " + portal.getPid() + " and user email: " + this.rolesUtils.getEmail() + " not found");
        }
        this.notificationsDAO.delete((Object)notifications);
    }

    public Notifications save(Portal portal, Notifications notifications) {
        Notifications saved = this.getUserNotifications(portal);
        if (saved != null) {
            notifications.setId(saved.getId());
        }
        notifications.setManagerEmail(this.rolesUtils.getEmail());
        notifications.setAaiId(this.rolesUtils.getAaiId());
        notifications.setPortalPid(portal.getPid());
        return (Notifications)this.notificationsDAO.save((Object)notifications);
    }

    public void updatePid(String oldPid, Portal portal) {
        this.log.debug("notifications service: updatePid");
        List notifications = this.notificationsDAO.findByPortalPid(oldPid);
        if (notifications != null) {
            notifications.forEach(notification -> {
                notification.setPortalPid(portal.getPid());
                this.notificationsDAO.save(notification);
            });
            this.log.debug("notifications saved!");
        }
    }

    public void deleteByPid(String pid) {
        this.notificationsDAO.deleteAll((Iterable)this.notificationsDAO.findByPortalPid(pid));
    }
}

