/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaauthorizationlibrary.authorization.controllers;

import eu.dnetlib.uoaauthorizationlibrary.AuthorizationConfiguration;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authorization-library"})
public class AuthorizationLibraryCheckDeployController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final AuthorizationConfiguration configuration;

    @Autowired
    public AuthorizationLibraryCheckDeployController(AuthorizationConfiguration configuration) {
        this.configuration = configuration;
    }

    @RequestMapping(value={"", "/", "/health_check"}, method={RequestMethod.GET})
    public ResponseEntity<String> hello() {
        this.log.debug("Hello from uoa-authorization-library!");
        return ResponseEntity.ok((Object)"Hello from uoa-authorization-library!");
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/health_check/advanced"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> checkEverything() {
        return ResponseEntity.ok(this.configuration.getProperties());
    }
}

