/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaauthorizationlibrary.authorization.security;

import eu.dnetlib.uoaauthorizationlibrary.authorization.security.OpenAIREAuthentication;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.stereotype.Component;

@Component(value="AuthorizationService")
public class AuthorizationService {
    public final String PORTAL_ADMIN = "PORTAL_ADMINISTRATOR";
    public final String ANONYMOUS_USER = "ROLE_ANONYMOUS";
    public final String REGISTERED_USER = "REGISTERED_USER";

    private String mapType(String type, boolean communityMap) {
        if (type.equals("organization")) {
            type = "institution";
        } else if (type.equals("ri") && communityMap) {
            type = "community";
        }
        while (type.contains(".")) {
            type = type.replace(".", "_");
        }
        return type;
    }

    public String curator(String type) {
        return "CURATOR_" + this.mapType(type, true).toUpperCase();
    }

    public String manager(String type, String id) {
        return this.mapType(type, true).toUpperCase() + "_" + id.toUpperCase() + "_MANAGER";
    }

    public String member(String type, String id) {
        return this.mapType(type, false).toUpperCase() + "_" + id.toUpperCase();
    }

    public boolean isPortalAdmin() {
        return this.getRoles().stream().anyMatch(authority -> authority.equalsIgnoreCase("PORTAL_ADMINISTRATOR"));
    }

    public boolean isCurator(String type) {
        return this.getRoles().stream().anyMatch(authority -> authority.equalsIgnoreCase(this.curator(type)));
    }

    public boolean isManager(String type, String id) {
        return this.getRoles().stream().anyMatch(authority -> authority.equalsIgnoreCase(this.manager(type, id)));
    }

    public boolean isMember(String type, String id) {
        return this.getRoles().stream().anyMatch(authority -> authority.equalsIgnoreCase(this.member(type, id)));
    }

    public List<String> getRoles() {
        Authentication authentication = this.getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public String getAaiId() {
        Authentication authentication = this.getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            if (authentication instanceof OpenAIREAuthentication) {
                return ((OpenAIREAuthentication)authentication).getUser().getSub();
            }
            return Objects.requireNonNull(this.getOidcUser()).getSubject();
        }
        return null;
    }

    public String getEmail() {
        Authentication authentication = this.getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            if (authentication instanceof OpenAIREAuthentication) {
                return ((OpenAIREAuthentication)authentication).getUser().getEmail();
            }
            return Objects.requireNonNull(this.getOidcUser()).getEmail();
        }
        return null;
    }

    private DefaultOidcUser getOidcUser() {
        Authentication authentication = this.getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)authentication;
            return (DefaultOidcUser)token.getPrincipal();
        }
        return null;
    }

    private Authentication getAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof OpenAIREAuthentication || authentication instanceof OAuth2AuthenticationToken) {
            return authentication;
        }
        return null;
    }
}

