/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaauthorizationlibrary.authorization.security;

import eu.dnetlib.uoaauthorizationlibrary.authorization.configuration.SecurityProperties;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class SwaggerAndEntryPoint
implements AuthenticationEntryPoint {
    private final SecurityProperties properties;
    private final AuthorizationService service;

    @Autowired
    public SwaggerAndEntryPoint(SecurityProperties properties, AuthorizationService service) {
        this.properties = properties;
        this.service = service;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        response.sendError(401, authException.getMessage());
    }

    public HttpSecurity configure(HttpSecurity http) throws Exception {
        http.exceptionHandling(handler -> handler.authenticationEntryPoint((AuthenticationEntryPoint)this));
        http.authorizeHttpRequests(auth -> {
            if (this.properties.isSwaggerAuthEnabled().booleanValue()) {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/documentation/swagger-ui/**", "/v3/api-docs/**"})).hasAuthority(this.service.PORTAL_ADMIN);
            }
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).permitAll();
        });
        return http;
    }
}

