/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaauthorizationlibrary.authorization.stateless;

import eu.dnetlib.uoaauthorizationlibrary.authorization.security.OpenAIREAuthentication;
import eu.dnetlib.uoaauthorizationlibrary.authorization.stateless.AuthorizationProvider;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthorizationFilter
implements Filter {
    private final AuthorizationProvider authorizationProvider;

    AuthorizationFilter(AuthorizationProvider authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req;
        OpenAIREAuthentication auth;
        if (request instanceof HttpServletRequest && (auth = this.authorizationProvider.getAuthentication(req = (HttpServletRequest)request)).isAuthenticated()) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        }
        chain.doFilter(request, response);
    }
}

