/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaauthorizationlibrary.authorization.stateless;

import eu.dnetlib.uoaauthorizationlibrary.authorization.configuration.SecurityProperties;
import eu.dnetlib.uoaauthorizationlibrary.authorization.stateless.UserInfo;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class AuthorizationUtils {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final SecurityProperties securityProperties;
    private final RestTemplate restTemplate;

    @Autowired
    AuthorizationUtils(SecurityProperties securityProperties, RestTemplate restTemplate) {
        this.securityProperties = securityProperties;
        this.restTemplate = restTemplate;
    }

    public UserInfo getUserInfo(HttpServletRequest request) {
        String url = this.securityProperties.getUserInfoUrl();
        try {
            if (url != null && this.hasCookie(request)) {
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, this.createHeaders(request), UserInfo.class, new Object[0]);
                return (UserInfo)response.getBody();
            }
            return null;
        }
        catch (RestClientException e) {
            this.log.error("{}: {}", (Object)url, (Object)e.getMessage());
            return null;
        }
    }

    private boolean hasCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            return Arrays.stream(cookies).anyMatch(cookie -> cookie.getName().equalsIgnoreCase(this.securityProperties.getSession()));
        }
        return false;
    }

    private HttpEntity<HttpHeaders> createHeaders(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.set("Cookie", request.getHeader("Cookie"));
        return new HttpEntity((MultiValueMap)headers);
    }
}

