/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaauthorizationlibrary.authorization.redis;

import eu.dnetlib.uoaauthorizationlibrary.authorization.configuration.SecurityProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.FlushMode;
import org.springframework.session.SaveMode;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisIndexedHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@EnableRedisIndexedHttpSession(flushMode=FlushMode.IMMEDIATE, saveMode=SaveMode.ALWAYS)
@Configuration
public class RedisConfig {
    private final SecurityProperties securityProperties;
    private static final Logger logger = LogManager.getLogger(RedisConfig.class);

    @Autowired
    public RedisConfig(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    @Bean
    public JedisConnectionFactory connectionFactory() {
        logger.info(String.format("Redis connection listens to %s:%s ", this.securityProperties.getRedis().getHost(), this.securityProperties.getRedis().getPort()));
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration(this.securityProperties.getRedis().getHost(), Integer.parseInt(this.securityProperties.getRedis().getPort()));
        if (this.securityProperties.getRedis().getPassword() != null) {
            configuration.setPassword(this.securityProperties.getRedis().getPassword());
        }
        return new JedisConnectionFactory(configuration);
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)this.connectionFactory());
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        return template;
    }

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(this.securityProperties.getSession());
        serializer.setCookiePath("/");
        serializer.setDomainName(this.securityProperties.getDomain());
        return serializer;
    }
}

