/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaauthorizationlibrary;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.uoaauthorizationlibrary.authorization.configuration.API;
import eu.dnetlib.uoaauthorizationlibrary.authorization.configuration.GlobalVars;
import eu.dnetlib.uoaauthorizationlibrary.authorization.configuration.SecurityProperties;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.CheckProperties;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={SecurityProperties.class, GlobalVars.class, API.class})
@ComponentScan(basePackages={"eu.dnetlib.uoaauthorizationlibrary.authorization"})
public class AuthorizationConfiguration {
    private final SecurityProperties properties;
    private final GlobalVars globalVars;
    private final CheckProperties checkProperties;

    @Autowired
    public AuthorizationConfiguration(SecurityProperties properties, GlobalVars globalVars, CheckProperties checkProperties) {
        this.properties = properties;
        this.globalVars = globalVars;
        this.checkProperties = checkProperties;
    }

    @Bean
    RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(new ObjectMapper());
        restTemplate.getMessageConverters().add(converter);
        return restTemplate;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.properties.getDomain() == null || this.properties.getDomain().isEmpty()) {
            throw new RuntimeException("authorization.security.domain is  missing!");
        }
        if (this.properties.getSession() == null || this.properties.getSession().isEmpty()) {
            throw new RuntimeException("authorization.security.session is  missing!");
        }
        this.checkProperties.checkProperties(this.properties);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("authorization.security.domain", this.properties.getDomain());
        map.put("authorization.security.session", this.properties.getSession());
        this.checkProperties.getProperties(map, this.properties);
        if (GlobalVars.date != null) {
            map.put("Date of deploy", GlobalVars.date.toString());
        }
        if (this.globalVars.getBuildDate() != null) {
            map.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            map.put("Version", this.globalVars.getVersion());
        }
        return map;
    }
}

