/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.ExceptionResponse;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.HttpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ExceptionsHandler {
    private final Logger log = LogManager.getLogger(this.getClass());

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<?> accessDenied(AccessDeniedException ex) {
        this.log.error(ex.getMessage(), (Throwable)ex);
        return new ResponseEntity((Object)new ExceptionResponse((Exception)ex, HttpStatus.UNAUTHORIZED), (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={HttpException.class})
    public ResponseEntity<?> http(HttpException ex) {
        this.log.error(ex.getMessage(), (Throwable)ex);
        return new ResponseEntity((Object)new ExceptionResponse(ex, ex.getHttpStatus()), (HttpStatusCode)ex.getHttpStatus());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<?> exception(RuntimeException ex) {
        this.log.error(ex.getMessage(), (Throwable)ex);
        return new ResponseEntity((Object)new ExceptionResponse(ex, HttpStatus.BAD_REQUEST), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

