/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaauthorizationlibrary.authorization.stateless;

import eu.dnetlib.uoaauthorizationlibrary.authorization.security.SecurityMode;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.SwaggerAndEntryPoint;
import eu.dnetlib.uoaauthorizationlibrary.authorization.stateless.AuthorizationFilter;
import eu.dnetlib.uoaauthorizationlibrary.authorization.stateless.AuthorizationProvider;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.stereotype.Component;

@Component
public class StatelessSecurityMode
implements SecurityMode {
    private final AuthorizationProvider provider;
    private final SwaggerAndEntryPoint swaggerAndEntryPoint;

    @Autowired
    public StatelessSecurityMode(AuthorizationProvider provider, SwaggerAndEntryPoint swaggerAndEntryPoint) {
        this.provider = provider;
        this.swaggerAndEntryPoint = swaggerAndEntryPoint;
    }

    @Override
    public HttpSecurity security(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable);
        http.sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        http.addFilterBefore((Filter)new AuthorizationFilter(this.provider), BasicAuthenticationFilter.class);
        return this.swaggerAndEntryPoint.configure(http);
    }
}

