package eu.dnetlib.domain.functionality;

import java.net.URL;

/**
 * This class represents a template for alert messages.
 * @author thanos
 * @see eu.dnetlib.api.functionality.AlertService
 * @see eu.dnetlib.functionality.alert.alerter.Alerter
 * @see AlertTopic
 * @see AlertSubscription
 *
 */
public class AlertTemplate implements Comparable<AlertTemplate> {
	private String templateId;
	private String title;
	private String message;
	private URL link;
	
	/**
	 * Construct a new alert template.
	 * @param templateId the unique identifier of this template
	 * @param title the title of the alerts generated by this template
	 * @param message the message of the alerts generated by this template
	 * @param link the link of the alerts generated by this template
	 */
	public AlertTemplate(final String templateId, final String title, final String message, final URL link) {
		this.templateId = templateId;
		this.title = title;
		this.message = message;
		this.link = link;
	}
	
	/**
	 * Construct a new alert template with template identifier, title, message and link set to null.
	 */
	public AlertTemplate() {
		this(null, null, null, null);
	}

	/**
	 * Get the unique identifier of this template.
	 * @return the unique identifier of this template
	 */
	public String getTemplateId() {
		return templateId;
	}
	
	/**
	 * Set the unique identifier of this template.
	 * @param templateId the unique identifier of this template
	 */
	public void setTemplateId(final String templateId) {
		this.templateId = templateId;
	}
	
	/**
	 * Get the title.
	 * @return the title of this template
	 */
	public String getTitle() {
		return title;
	}
	
	/**
	 * Set the title.
	 * @param title the title of this template
	 */
	public void setTitle(final String title) {
		this.title = title;
	}
	
	/**
	 * Get the message.
	 * @return the message of this template
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * Set the message.
	 * @param message the message of this template
	 */
	public void setMessage(final String message) {
		this.message = message;
	}
	
	/**
	 * Get the link.
	 * @return the link of this template
	 */
	public URL getLink() {
		return link;
	}
	
	/**
	 * Set the link.
	 * @param link the link of this template
	 */
	public void setLink(final URL link) {
		this.link = link;
	}
	
	@Override
	public int compareTo(final AlertTemplate template) {
		return templateId.compareTo(template.templateId);
	}
	
	@Override
	public boolean equals(final Object object) {
		if (!(object instanceof AlertTemplate))
			return false;
		final AlertTemplate template = (AlertTemplate) object;
		return (templateId == null) ? (template.templateId == null) : templateId.equals(template.templateId);
	}
	
	@Override
	public int hashCode() {
		return (templateId == null) ? 0 : templateId.hashCode();
	}
	
	@Override
	public String toString() {
		return templateId;
	}
}
