package eu.dnetlib.openaire.user.login.utils;

import com.google.gson.JsonObject;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Date;

public class JWTGenerator {

    private static final Logger logger = Logger.getLogger(JWTGenerator.class);

    /*public static String generateToken(MigrationUser u, String secret) {
        Claims claims = Jwts.claims().setSubject(u.getUsername());
        claims.put("fullname", u.getFullname() + "");
        claims.put("userId", u.getId() + "");
        claims.put("email", u.getEmail() + "");
        claims.put("role", u.getRoleId());

        //expiration
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        long ttlMillis = 1800000;
        long expMillis = nowMillis + ttlMillis;
        Date exp = new Date(expMillis);

        return Jwts.builder()
                .setClaims(claims)
                .setExpiration(exp)
                .signWith(SignatureAlgorithm.HS512, secret)
                .compact();
    }*/

    public static String generateToken(OIDCAuthenticationToken authOIDC, String secret) {

        try {

            JsonObject userInfo = authOIDC.getUserInfo().getSource();
            Claims claims = Jwts.claims().setSubject(authOIDC.getUserInfo().getSub());
            claims.put("fullname", URLEncoder.encode(authOIDC.getUserInfo().getName(), "UTF-8") + "");

            if (authOIDC.getUserInfo().getGivenName() == null){
                logger.info("User: " + authOIDC.getUserInfo().getName() + "doesn't have first name");
                claims.put("firstname", URLEncoder.encode(" ", "UTF-8") + "");
            } else {
                claims.put("firstname", URLEncoder.encode(authOIDC.getUserInfo().getGivenName(), "UTF-8") + "");
            }
            if (authOIDC.getUserInfo().getFamilyName() == null){
                logger.info("User: " + authOIDC.getUserInfo().getName() + "doesn't have first name");
                claims.put("lastname", URLEncoder.encode(" ", "UTF-8") + "");
            } else {
                claims.put("lastname", URLEncoder.encode(authOIDC.getUserInfo().getFamilyName(), "UTF-8") + "");
            }

            claims.put("email", authOIDC.getUserInfo().getEmail() + "");

//            if (userInfo.getAsJsonArray("eduPersonScopedAffiliation").toString() != null) {
//                claims.put("role", URLEncoder.encode(userInfo.getAsJsonArray("edu_person_scoped_affiliations").toString(), "UTF-8") + "");
//            }

            if (userInfo.getAsJsonArray("edu_person_entitlements") == null){
                logger.info("User: " + authOIDC.getUserInfo().getName() + "doesn't have role");
                claims.put("role", URLEncoder.encode(" ", "UTF-8") + "");
            } else {
                claims.put("role", URLEncoder.encode(userInfo.getAsJsonArray("edu_person_entitlements").toString(), "UTF-8") + "");
            }

            //TODO remove, We don't need it but if we are going to use it, we need to check if the user has affiliation
            //claims.put("edu_person_scoped_affiliations", URLEncoder.encode(userInfo.getAsJsonArray("edu_person_scoped_affiliations").toString(), "UTF-8") + "");

            //TODO remove
            //TODO THIS IS TEST
//            claims.put("fullname", URLEncoder.encode("Σοφία Μπαλτζή", "UTF-8") + "");
//            claims.put("firstname", URLEncoder.encode("Σοφία", "UTF-8") + "");
//            claims.put("lastname", URLEncoder.encode("Μπαλτζή", "UTF-8") + "");
//            claims.put("email", "sofie.mpl@gmail.com" + "");
//            claims.put("edu_person_scoped_affiliations", "faculty");

            Date exp = new Date(authOIDC.getIdToken().getJWTClaimsSet().getExpirationTime().getTime());
//            logger.info("expirationTime: "+ exp);

            //TODO DELETE LOGS
//            logger.info("\n////////////////////////////////////////////////////////////////////////////////////////////////\n");
//            logger.info("fullName: " + authOIDC.getUserInfo().getName());
//            logger.info("firstName: " + authOIDC.getUserInfo().getGivenName());
//            logger.info("lastName: " + authOIDC.getUserInfo().getFamilyName());
//            logger.info("email: " + authOIDC.getUserInfo().getEmail());
//            //logger.info("Check everything");
//            logger.info("locale: " + authOIDC.getUserInfo().getSource());
//            logger.info("role: " + userInfo.getAsJsonArray("edu_person_entitlements").toString());
//            //logger.info("affiliation: " + userInfo.getAsJsonArray("edu_person_scoped_affiliations").toString());
//            logger.info("expirationTime: " + exp);
//            logger.info("\n////////////////////////////////////////////////////////////////////////////////////////////////\n");

                return Jwts.builder()
                        .setClaims(claims)
                        .setExpiration(exp)
                        .signWith(SignatureAlgorithm.HS512, secret)
                        .compact();

        } catch (ParseException e) {
            e.printStackTrace();
            logger.error("JWT Parse Exception from getting Expiration Time ", e);
            return "error";
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error("UnsupportedEncodingException UTF-8 ", e);
            return "error";
        }
    }


     public static JsonObject generateJsonToken(OIDCAuthenticationToken authOIDC) {
         try {

            JsonObject userInfo = authOIDC.getUserInfo().getSource();
            JsonObject userInfo2 = new JsonObject();

            if (authOIDC.getUserInfo().getSub() == null) {
                logger.info("User doesn't have sub");
                userInfo2.addProperty("sub", "");
            } else {
                userInfo2.addProperty("sub", URLEncoder.encode(authOIDC.getUserInfo().getSub(), "UTF-8"));
            }
            if (authOIDC.getUserInfo().getName() == null) {
                logger.info("User doesn't have fullname");
                userInfo2.addProperty("fullname", "");
            } else {
                userInfo2.addProperty("fullname", URLEncoder.encode(authOIDC.getUserInfo().getName(), "UTF-8"));
            }
            if (authOIDC.getUserInfo().getGivenName() == null){
                logger.info("User: " + authOIDC.getUserInfo().getName() + "doesn't have first name");
//                userInfo2.addProperty("firstname", URLEncoder.encode(" ", "UTF-8") + "");
                userInfo2.addProperty("firstname", "");
            } else {
                userInfo2.addProperty("firstname", URLEncoder.encode(authOIDC.getUserInfo().getGivenName(), "UTF-8") + "");
            }
            if (authOIDC.getUserInfo().getFamilyName() == null){
                logger.info("User: " + authOIDC.getUserInfo().getName() + "doesn't have first name");
//                userInfo2.addProperty("lastname", URLEncoder.encode(" ", "UTF-8") + "");
                userInfo2.addProperty("lastname", "");
            } else {
                userInfo2.addProperty("lastname", URLEncoder.encode(authOIDC.getUserInfo().getFamilyName(), "UTF-8") + "");
            }
            userInfo2.addProperty("email", authOIDC.getUserInfo().getEmail() + "");

            if (userInfo.getAsJsonArray("edu_person_entitlements") == null){
                logger.info("User: " + authOIDC.getUserInfo().getName() + "doesn't have role");
//                userInfo2.addProperty("role", URLEncoder.encode(" ", "UTF-8") + "");
                userInfo2.addProperty("role", "");
            } else {
                userInfo2.addProperty("role", URLEncoder.encode(userInfo.getAsJsonArray("edu_person_entitlements").toString(), "UTF-8") + "");
            }

            logger.info("UserINFO: " + userInfo2.toString());
            return userInfo2;

        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error("UnsupportedEncodingException UTF-8 ", e);
            JsonObject error = new JsonObject();
            error.addProperty("error", "UnsupportedEncodingException UTF-8 " + e);
            return error;
        }

     }

    //TODO DELETE IF IT IS NOT NECESSARY
    public static String generateAccessToken(OIDCAuthenticationToken authOIDC, String secret) {
        Claims claims = Jwts.claims().setId(authOIDC.getAccessTokenValue());

        //TODO DELETE LOGS
        logger.info("\n////////////////////////////////////////////////////////////////////////////////////////////////\n");
        logger.info("access token: " + authOIDC.getAccessTokenValue());
        logger.info("\n////////////////////////////////////////////////////////////////////////////////////////////////\n");

        return Jwts.builder()
                .setClaims(claims)
                .signWith(SignatureAlgorithm.HS512, secret)
                .compact();
    }


    public static String generateToken(UserInfo user, String secret) {
        try {

            JsonObject userInfo = user.getSource();

            Claims claims = Jwts.claims().setSubject(user.getSub());
            claims.put("email", user.getEmail() + "");
            claims.put("role", URLEncoder.encode(userInfo.getAsJsonArray("edu_person_entitlements").toString(), "UTF-8") + "");

            return Jwts.builder()
                    .setClaims(claims)
                    .signWith(SignatureAlgorithm.HS512, secret)
                    .compact();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error("UnsupportedEncodingException UTF-8 ", e);
            return "error";
        }
    }

}




// How to add it manually
//        long nowMillis = System.currentTimeMillis();
//        //This is my token
//        try {
//            String jwt = Jwts.builder()
//                    .setSubject("Argiro")
//                    .setExpiration(new Date(nowMillis+1800000))
//                    .claim("fullname", "Argiro Kokogianaki")
//                    .claim("id", "8")
//                    .claim("email", "argiro@gmail.com")
//                    .claim("role","2")
//                    .signWith(
//                            SignatureAlgorithm.HS512,
//                            "my-very-secret".getBytes("UTF-8")
//                    )
//                    .compact();
